/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.groovy.console.GroovyShellCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyShellCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        GrExpression invokedExpression;
        PsiElement ppparent;
        PsiFile file = parameters.getOriginalFile();
        if (!(file instanceof GroovyShellCodeFragment)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (!(parent instanceof GrReferenceExpression) || ((GrReferenceExpression)parent).isQualified()) {
            return;
        }
        if (PsiUtil.isExpressionStatement(parent)) {
            GroovyShellCompletionContributor.addAllCommands(result);
        } else if (parent.getParent() instanceof GrCommandArgumentList && (ppparent = parent.getParent().getParent()) instanceof GrMethodCall && GroovyShellCompletionContributor.isFirstArg((GrMethodCall)ppparent, parent) && (invokedExpression = ((GrMethodCall)ppparent).getInvokedExpression()) instanceof GrReferenceExpression && !((GrReferenceExpression)invokedExpression).isQualified()) {
            String name = ((GrReferenceExpression)invokedExpression).getReferenceName();
            if ("help".equals(name)) {
                GroovyShellCompletionContributor.addAllCommands(result);
            } else if ("show".equals(name)) {
                GroovyShellCompletionContributor.add(result, "classes");
                GroovyShellCompletionContributor.add(result, "imports");
                GroovyShellCompletionContributor.add(result, "preferences");
                GroovyShellCompletionContributor.add(result, "all");
            } else if ("purge".equals(name)) {
                GroovyShellCompletionContributor.add(result, "variables");
                GroovyShellCompletionContributor.add(result, "classes");
                GroovyShellCompletionContributor.add(result, "imports");
                GroovyShellCompletionContributor.add(result, "preferences");
                GroovyShellCompletionContributor.add(result, "all");
            } else if ("record".equals(name)) {
                GroovyShellCompletionContributor.add(result, "start");
                GroovyShellCompletionContributor.add(result, "stop");
                GroovyShellCompletionContributor.add(result, "status");
            } else if ("history".equals(name)) {
                GroovyShellCompletionContributor.add(result, "show");
                GroovyShellCompletionContributor.add(result, "recall");
                GroovyShellCompletionContributor.add(result, "flush");
                GroovyShellCompletionContributor.add(result, "clear");
            }
        }
    }

    private static void add(CompletionResultSet result, String name) {
        result.addElement((LookupElement)LookupElementBuilder.create((String)name));
    }

    private static void addAllCommands(CompletionResultSet result) {
        GroovyShellCompletionContributor.add(result, "help");
        GroovyShellCompletionContributor.add(result, "exit");
        GroovyShellCompletionContributor.add(result, "quit");
        GroovyShellCompletionContributor.add(result, "display");
        GroovyShellCompletionContributor.add(result, "clear");
        GroovyShellCompletionContributor.add(result, "show");
        GroovyShellCompletionContributor.add(result, "inspect");
        GroovyShellCompletionContributor.add(result, "purge");
        GroovyShellCompletionContributor.add(result, "edit");
        GroovyShellCompletionContributor.add(result, "load");
        GroovyShellCompletionContributor.add(result, "save");
        GroovyShellCompletionContributor.add(result, "record");
        GroovyShellCompletionContributor.add(result, "history");
        GroovyShellCompletionContributor.add(result, "alias");
        GroovyShellCompletionContributor.add(result, "set");
    }

    private static boolean isFirstArg(GrMethodCall ppparent, PsiElement parent) {
        GroovyPsiElement[] arguments = ppparent.getArgumentList().getAllArguments();
        return arguments.length > 0 && arguments[0] == parent;
    }
}

