/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.console.GroovyShellRunner;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class DefaultGroovyShellRunner
extends GroovyShellRunner {
    @Override
    public String getWorkingDirectory(Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return contentRoots[0].getPath();
    }

    @Override
    public JavaParameters createJavaParameters(Module module) throws ExecutionException {
        JavaParameters res = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(res, module, "org.codehaus.groovy.tools.shell.Main", false, true);
        res.setWorkingDirectory(this.getWorkingDirectory(module));
        return res;
    }

    @Override
    public boolean canRun(Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return contentRoots.length > 0 && DefaultGroovyShellRunner.hasGroovyWithNeededJars(module);
    }

    @Override
    public String getTitle(Module module) {
        String homePath = LibrariesUtil.getGroovyHomePath(module);
        assert (homePath != null);
        String version = GroovyConfigUtils.getInstance().getSDKVersion(homePath);
        return version == "undefined" ? "" : " (Groovy " + version + ")";
    }

    static boolean hasGroovyWithNeededJars(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return (facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null) && facade.findClass("groovy.ui.GroovyMain", scope) != null && facade.findClass("org.fusesource.jansi.AnsiConsole", scope) != null;
    }
}

