/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.plugins.groovy.config.AbstractConfigUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class GroovyConfigUtils
extends AbstractConfigUtils {
    public static final Pattern GROOVY_ALL_JAR_PATTERN = Pattern.compile("groovy-all(-(.*))?\\.jar");
    public static final Pattern GROOVY_JAR_PATTERN = Pattern.compile("groovy(-(\\d.*))?\\.jar");
    public static final String NO_VERSION = "<no version>";
    public static final String GROOVY1_7 = "1.7";
    public static final String GROOVY1_8 = "1.8";
    public static final String GROOVY2_0 = "2.0";
    public static final String GROOVY2_1 = "2.1";
    public static final String GROOVY2_2 = "2.2";
    public static final String GROOVY2_2_2 = "2.2.2";
    public static final String GROOVY2_3 = "2.3";
    private static GroovyConfigUtils myGroovyConfigUtils;

    private GroovyConfigUtils() {
    }

    public static GroovyConfigUtils getInstance() {
        if (myGroovyConfigUtils == null) {
            myGroovyConfigUtils = new GroovyConfigUtils(){
                {
                    this.STARTER_SCRIPT_FILE_NAME = "groovy";
                }
            };
        }
        return myGroovyConfigUtils;
    }

    public static File[] getGroovyAllJars(String path) {
        return LibrariesUtil.getFilesInDirectoryByPattern(path, GROOVY_ALL_JAR_PATTERN);
    }

    public static boolean matchesGroovyAll(String name) {
        return GROOVY_ALL_JAR_PATTERN.matcher(name).matches() && !name.contains("src") && !name.contains("doc");
    }

    @Override
    public String getSDKVersion(String path) {
        String groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/lib", GROOVY_JAR_PATTERN, "META-INF/MANIFEST.MF");
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/lib", GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/embeddable", GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path, GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        return groovyJarVersion == null ? "undefined" : groovyJarVersion;
    }

    @Override
    public boolean isSDKLibrary(Library library) {
        if (library == null) {
            return false;
        }
        return LibrariesUtil.getGroovyLibraryHome(library.getFiles(OrderRootType.CLASSES)) != null;
    }

    public String getSDKVersion(final Module module) {
        return (String)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<String>(){

            public CachedValueProvider.Result<String> compute() {
                String path = LibrariesUtil.getGroovyHomePath(module);
                return CachedValueProvider.Result.create((Object)(path == null ? null : GroovyConfigUtils.this.getSDKVersion(path)), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
            }
        });
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version) {
        return this.isVersionAtLeast(psiElement, version, true);
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version, boolean unknownResult) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return unknownResult;
        }
        String sdkVersion = this.getSDKVersion(module);
        if (sdkVersion == null) {
            return unknownResult;
        }
        return sdkVersion.compareTo(version) >= 0;
    }

    public String getSDKVersion(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return NO_VERSION;
        }
        String s = this.getSDKVersion(module);
        return s != null ? s : NO_VERSION;
    }

    @Override
    public boolean isSDKHome(VirtualFile file) {
        String path;
        return file != null && file.isDirectory() && (LibrariesUtil.getFilesInDirectoryByPattern((path = file.getPath()) + "/lib", GROOVY_JAR_PATTERN).length > 0 || LibrariesUtil.getFilesInDirectoryByPattern(path + "/embeddable", GROOVY_ALL_JAR_PATTERN).length > 0 || LibrariesUtil.getFilesInDirectoryByPattern(path, GROOVY_JAR_PATTERN).length > 0);
    }

    public String getSDKLibVersion(Library library) {
        return this.getSDKVersion(LibrariesUtil.getGroovyLibraryHome(library));
    }

    public Collection<String> getSDKVersions(Library[] libraries) {
        return ContainerUtil.map2List((Object[])libraries, (Function)new Function<Library, String>(){

            public String fun(Library library) {
                return GroovyConfigUtils.this.getSDKLibVersion(library);
            }
        });
    }
}

