/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.compiler.ExcludeFromStubGenerationAction;

public class GroovyCompilerLoader
extends AbstractProjectComponent {
    public static final String GROOVY_STUBS = "groovyStubs";

    public GroovyCompilerLoader(Project project) {
        super(project);
    }

    public static PsiClass findClassByStub(Project project, VirtualFile stubFile) {
        String[] components = StringUtil.trimEnd((String)stubFile.getPath(), (String)".java").split("[\\\\/]");
        int stubs = Arrays.asList(components).indexOf(GROOVY_STUBS);
        if (stubs < 0 || stubs >= components.length - 3) {
            return null;
        }
        String moduleName = components[stubs + 1];
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        if (module == null) {
            return null;
        }
        String fqn = StringUtil.join(Arrays.asList(components).subList(stubs + 3, components.length), (String)".");
        return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.moduleScope((Module)module));
    }

    public void projectOpened() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        compilerManager.addCompilableFileType((FileType)GroovyFileType.GROOVY_FILE_TYPE);
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                FileEditorManager fileEditorManager;
                FileEditor[] editors;
                PsiClass psiClass;
                if (file.getName().endsWith(".java") && file.getPath().contains(GroovyCompilerLoader.GROOVY_STUBS) && (psiClass = GroovyCompilerLoader.findClassByStub(GroovyCompilerLoader.this.myProject, file)) != null && (editors = (fileEditorManager = FileEditorManager.getInstance((Project)GroovyCompilerLoader.this.myProject)).getEditors(file)).length != 0) {
                    GroovyCompilerLoader.this.decorateStubFile(file, fileEditorManager, editors[0]);
                }
            }
        });
    }

    private void decorateStubFile(final VirtualFile file, FileEditorManager fileEditorManager, FileEditor editor) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText("This stub is generated for Groovy class to make Groovy-Java cross-compilation possible");
        panel.createActionLabel("Go to the Groovy class", new Runnable(){

            @Override
            public void run() {
                PsiClass original = GroovyCompilerLoader.findClassByStub(GroovyCompilerLoader.this.myProject, file);
                if (original != null) {
                    original.navigate(true);
                }
            }
        });
        panel.createActionLabel("Exclude from stub generation", new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = GroovyCompilerLoader.findClassByStub(GroovyCompilerLoader.this.myProject, file);
                if (psiClass != null) {
                    ExcludeFromStubGenerationAction.doExcludeFromStubGeneration(psiClass.getContainingFile());
                }
            }
        });
        fileEditorManager.addTopComponent(editor, (JComponent)panel);
    }

    public String getComponentName() {
        return "GroovyCompilerLoader";
    }
}

