/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ConstructorCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.DelegatingCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrBinaryExprInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrChangeVariableType;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrConstructorInvocationInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrEnumConstantInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrIndexPropertyInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrListOrMapInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrMethodCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrNewExpressionInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GroovyAssignabilityCheckInspection;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrBuilderMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParamsEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrInnerClassConstructorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyTypeCheckVisitor
extends BaseInspectionVisitor {
    private static final Logger LOG = Logger.getInstance(GroovyAssignabilityCheckInspection.class);

    private boolean checkCallApplicability(PsiType type, boolean checkUnknownArgs, CallInfo info) {
        PsiType[] argumentTypes = info.getArgumentTypes();
        GrExpression invoked = info.getInvokedExpression();
        if (invoked == null) {
            return true;
        }
        if (type instanceof GrClosureType) {
            if (argumentTypes == null) {
                return true;
            }
            GrClosureSignatureUtil.ApplicabilityResult result = PsiUtil.isApplicableConcrete(argumentTypes, (GrClosureType)type, info.getCall());
            switch (result) {
                case inapplicable: {
                    this.registerCannotApplyError(invoked.getText(), info);
                    return false;
                }
                case canBeApplicable: {
                    if (checkUnknownArgs) {
                        this.highlightUnknownArgs(info);
                    }
                    return !checkUnknownArgs;
                }
            }
            return true;
        }
        if (type != null) {
            GroovyResolveResult[] calls;
            for (GroovyResolveResult result : calls = ResolveUtil.getMethodCandidates(type, "call", (PsiElement)invoked, argumentTypes)) {
                PsiElement resolved = result.getElement();
                if (!(resolved instanceof PsiMethod && !result.isInvokedOnProperty() ? !this.checkMethodApplicability(result, checkUnknownArgs, info) : resolved instanceof PsiField && !this.checkCallApplicability(((PsiField)resolved).getType(), checkUnknownArgs && calls.length == 1, info))) continue;
                return false;
            }
            if (calls.length == 0 && !(invoked instanceof GrString)) {
                this.registerCannotApplyError(invoked.getText(), info);
            }
            return true;
        }
        return true;
    }

    private boolean checkCannotInferArgumentTypes(CallInfo info) {
        if (info.getArgumentTypes() != null) {
            return true;
        }
        this.highlightUnknownArgs(info);
        return false;
    }

    private <T extends GroovyPsiElement> boolean checkConstructorApplicability(GroovyResolveResult constructorResolveResult, CallInfo<T> info, boolean checkUnknownArgs) {
        PsiType[] newTypes;
        GrExpression[] exprArgs;
        PsiElement element = constructorResolveResult.getElement();
        LOG.assertTrue(element instanceof PsiMethod && ((PsiMethod)element).isConstructor(), (Object)element);
        PsiMethod constructor = (PsiMethod)element;
        GrArgumentList argList = info.getArgumentList();
        if (argList != null && (exprArgs = argList.getExpressionArguments()).length == 0 && !PsiUtil.isConstructorHasRequiredParameters(constructor)) {
            return true;
        }
        PsiType[] types = info.getArgumentTypes();
        PsiClass containingClass = constructor.getContainingClass();
        if (types != null && containingClass != null && (newTypes = GrInnerClassConstructorUtil.addEnclosingArgIfNeeded(types, info.getCall(), containingClass)).length != types.length) {
            return this.checkMethodApplicability(constructorResolveResult, checkUnknownArgs, new DelegatingCallInfo<T>(info){

                @Override
                public PsiType[] getArgumentTypes() {
                    return newTypes;
                }
            });
        }
        return this.checkMethodApplicability(constructorResolveResult, checkUnknownArgs, info);
    }

    private void processConstructorCall(ConstructorCallInfo<?> info) {
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getArgumentList())) {
            return;
        }
        if (!this.checkCannotInferArgumentTypes(info)) {
            return;
        }
        GroovyResolveResult constructorResolveResult = info.advancedResolve();
        PsiElement constructor = constructorResolveResult.getElement();
        if (constructor != null) {
            if (!this.checkConstructorApplicability(constructorResolveResult, info, true)) {
                return;
            }
        } else {
            GroovyResolveResult[] results = info.multiResolve();
            if (results.length > 0) {
                for (GroovyResolveResult result : results) {
                    PsiElement resolved = result.getElement();
                    if (!(resolved instanceof PsiMethod) || this.checkConstructorApplicability(result, info, false)) continue;
                    return;
                }
                this.registerError(info.getElementToHighlight(), GroovyBundle.message("constructor.call.is.ambiguous", new Object[0]), null, ProblemHighlightType.GENERIC_ERROR);
            } else {
                PsiElement element;
                GroovyResolveResult[] resolveResults;
                boolean hasNamedArgs;
                GrExpression[] expressionArguments = info.getExpressionArguments();
                boolean hasClosureArgs = info.getClosureArguments().length > 0;
                boolean bl = hasNamedArgs = info.getNamedArguments().length > 0;
                if ((hasClosureArgs || hasNamedArgs && expressionArguments.length > 0 || !hasNamedArgs && expressionArguments.length > 0 && !GroovyTypeCheckVisitorHelper.isOnlyOneMapParam(expressionArguments)) && (resolveResults = info.multiResolveClass()).length == 1 && (element = resolveResults[0].getElement()) instanceof PsiClass) {
                    this.registerError(info.getElementToHighlight(), GroovyBundle.message("cannot.apply.default.constructor", ((PsiClass)element).getName()), null, ProblemHighlightType.GENERIC_ERROR);
                    return;
                }
            }
        }
        this.checkNamedArgumentsType(info);
    }

    private boolean checkForImplicitEnumAssigning(PsiType expectedType, GrExpression expression, GroovyPsiElement elementToHighlight) {
        if (!(expectedType instanceof PsiClassType)) {
            return false;
        }
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(elementToHighlight, "1.8")) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)expectedType).resolve();
        if (resolved == null || !resolved.isEnum()) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!type.equalsToText("groovy.lang.GString") && !type.equalsToText("java.lang.String")) {
            return false;
        }
        Object result = GroovyConstantExpressionEvaluator.evaluate(expression);
        if (result == null || !(result instanceof String)) {
            this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.WEAK_WARNING, new Object[]{GroovyBundle.message("cannot.assign.string.to.enum.0", expectedType.getPresentableText())});
        } else {
            PsiField field = resolved.findFieldByName((String)result, true);
            if (!(field instanceof PsiEnumConstant)) {
                this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{GroovyBundle.message("cannot.find.enum.constant.0.in.enum.1", result, expectedType.getPresentableText())});
            }
        }
        return true;
    }

    private void checkIndexProperty(CallInfo<? extends GrIndexProperty> info) {
        PsiType[] types;
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getArgumentList())) {
            return;
        }
        if (!this.checkCannotInferArgumentTypes(info)) {
            return;
        }
        PsiType type = info.getQualifierInstanceType();
        if (GroovyTypeCheckVisitorHelper.checkSimpleArrayAccess(info, type, types = info.getArgumentTypes())) {
            return;
        }
        GroovyResolveResult[] results = info.multiResolve();
        GroovyResolveResult resolveResult = info.advancedResolve();
        if (resolveResult.getElement() != null) {
            PsiElement resolved = resolveResult.getElement();
            if (resolved instanceof PsiMethod && !resolveResult.isInvokedOnProperty()) {
                this.checkMethodApplicability(resolveResult, true, info);
            } else if (resolved instanceof GrField) {
                this.checkCallApplicability(((GrField)resolved).getTypeGroovy(), true, info);
            } else if (resolved instanceof PsiField) {
                this.checkCallApplicability(((PsiField)resolved).getType(), true, info);
            }
        } else if (results.length > 0) {
            for (GroovyResolveResult result : results) {
                PsiElement resolved = result.getElement();
                if (!(resolved instanceof PsiMethod && !result.isInvokedOnProperty() ? !this.checkMethodApplicability(result, false, info) : (resolved instanceof GrField ? !this.checkCallApplicability(((GrField)resolved).getTypeGroovy(), false, info) : resolved instanceof PsiField && !this.checkCallApplicability(((PsiField)resolved).getType(), false, info)))) continue;
                return;
            }
            this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("method.call.is.ambiguous", new Object[0])});
        } else {
            String typesString = GroovyTypeCheckVisitorHelper.buildArgTypesList(types);
            this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("cannot.find.operator.overload.method", typesString)});
        }
    }

    private <T extends GroovyPsiElement> boolean checkMethodApplicability(final GroovyResolveResult methodResolveResult, boolean checkUnknownArgs, final CallInfo<T> info) {
        PsiType type;
        GrExpression qualifierExpression;
        PsiElement element = methodResolveResult.getElement();
        if (!(element instanceof PsiMethod)) {
            return true;
        }
        if (element instanceof GrBuilderMethod) {
            return true;
        }
        PsiMethod method = (PsiMethod)element;
        if ("call".equals(method.getName()) && info.getInvokedExpression() instanceof GrReferenceExpression && (qualifierExpression = ((GrReferenceExpression)info.getInvokedExpression()).getQualifierExpression()) != null && (type = qualifierExpression.getType()) instanceof GrClosureType) {
            GrClosureSignatureUtil.ApplicabilityResult result = PsiUtil.isApplicableConcrete(info.getArgumentTypes(), (GrClosureType)type, info.getInvokedExpression());
            switch (result) {
                case inapplicable: {
                    this.highlightInapplicableMethodUsage(methodResolveResult, info, method);
                    return false;
                }
                case canBeApplicable: {
                    if (checkUnknownArgs) {
                        this.highlightUnknownArgs(info);
                    }
                    return !checkUnknownArgs;
                }
            }
            return true;
        }
        if (method instanceof GrGdkMethod && info.getInvokedExpression() instanceof GrReferenceExpression) {
            GrReferenceExpression invoked = (GrReferenceExpression)info.getInvokedExpression();
            GrExpression qualifier = PsiImplUtil.getRuntimeQualifier(invoked);
            if (qualifier == null && method.getName().equals("call")) {
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(invoked.getProject());
                final GrReferenceExpression callRef = factory.createReferenceExpressionFromText("qualifier.call", invoked);
                callRef.setQualifier(invoked);
                return this.checkMethodApplicability(methodResolveResult, checkUnknownArgs, new DelegatingCallInfo<T>(info){

                    @Override
                    public GrExpression getInvokedExpression() {
                        return callRef;
                    }

                    @Override
                    public GroovyResolveResult advancedResolve() {
                        return methodResolveResult;
                    }

                    @Override
                    public GroovyResolveResult[] multiResolve() {
                        return new GroovyResolveResult[]{methodResolveResult};
                    }

                    @Override
                    public PsiType getQualifierInstanceType() {
                        return info.getInvokedExpression().getType();
                    }
                });
            }
            PsiMethod staticMethod = ((GrGdkMethod)method).getStaticMethod();
            PsiType qualifierType = info.getQualifierInstanceType();
            if (qualifierType != null && !GdkMethodUtil.isCategoryMethod(staticMethod, qualifierType, qualifier, methodResolveResult.getSubstitutor()) && !GroovyTypeCheckVisitorHelper.checkCategoryQualifier(invoked, qualifier, staticMethod, methodResolveResult.getSubstitutor())) {
                this.registerError(info.getHighlightElementForCategoryQualifier(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyInspectionBundle.message("category.method.0.cannot.be.applied.to.1", method.getName(), qualifierType.getCanonicalText())});
                return false;
            }
        }
        if (info.getArgumentTypes() == null) {
            return true;
        }
        GrClosureSignatureUtil.ApplicabilityResult applicable = PsiUtil.isApplicableConcrete(info.getArgumentTypes(), method, methodResolveResult.getSubstitutor(), info.getCall(), false);
        switch (applicable) {
            case inapplicable: {
                this.highlightInapplicableMethodUsage(methodResolveResult, info, method);
                return false;
            }
            case canBeApplicable: {
                if (checkUnknownArgs) {
                    this.highlightUnknownArgs(info);
                }
                return !checkUnknownArgs;
            }
        }
        return true;
    }

    private void checkMethodCall(CallInfo<? extends GrMethodCall> info) {
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getArgumentList())) {
            return;
        }
        if (info.getInvokedExpression() instanceof GrReferenceExpression) {
            GrExpression qualifier;
            GrReferenceExpression referenceExpression = (GrReferenceExpression)info.getInvokedExpression();
            GroovyResolveResult resolveResult = info.advancedResolve();
            GroovyResolveResult[] results = info.multiResolve();
            PsiElement resolved = resolveResult.getElement();
            if (resolved == null && (qualifier = referenceExpression.getQualifierExpression()) == null && GrHighlightUtil.isDeclarationAssignment(referenceExpression)) {
                return;
            }
            if (!this.checkCannotInferArgumentTypes(info)) {
                return;
            }
            if (resolved != null) {
                if (resolved instanceof PsiMethod && !resolveResult.isInvokedOnProperty()) {
                    this.checkMethodApplicability(resolveResult, true, info);
                } else {
                    this.checkCallApplicability(referenceExpression.getType(), true, info);
                }
            } else if (results.length > 0) {
                for (GroovyResolveResult result : results) {
                    PsiElement current = result.getElement();
                    if (!(current instanceof PsiMethod && !result.isInvokedOnProperty() ? !this.checkMethodApplicability(result, false, info) : !this.checkCallApplicability(referenceExpression.getType(), false, info))) continue;
                    return;
                }
                this.registerError(info.getElementToHighlight(), GroovyBundle.message("method.call.is.ambiguous", new Object[0]));
            }
        } else if (info.getInvokedExpression() != null) {
            PsiType type = info.getInvokedExpression().getType();
            this.checkCallApplicability(type, true, info);
        }
        this.checkNamedArgumentsType(info);
    }

    private void checkNamedArgumentsType(CallInfo<?> info) {
        Object rawCall = info.getCall();
        if (!(rawCall instanceof GrCall)) {
            return;
        }
        GrCall call = (GrCall)rawCall;
        GrNamedArgument[] namedArguments = PsiUtil.getFirstMapNamedArguments(call);
        if (namedArguments.length == 0) {
            return;
        }
        Map<String, NamedArgumentDescriptor> map = GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders(call, null, false);
        if (map == null) {
            return;
        }
        for (GrNamedArgument namedArgument : namedArguments) {
            PsiType expressionType;
            GrExpression namedArgumentExpression;
            String labelName = namedArgument.getLabelName();
            NamedArgumentDescriptor descriptor = map.get(labelName);
            if (descriptor == null || (namedArgumentExpression = namedArgument.getExpression()) == null || GroovyTypeCheckVisitorHelper.getTupleInitializer(namedArgumentExpression) != null || PsiUtil.isRawClassMemberAccess(namedArgumentExpression) || (expressionType = TypesUtil.boxPrimitiveType(namedArgumentExpression.getType(), call.getManager(), call.getResolveScope())) == null || descriptor.checkType(expressionType, call)) continue;
            this.registerError((PsiElement)namedArgumentExpression, ProblemHighlightType.GENERIC_ERROR, new Object[]{"Type of argument '" + labelName + "' can not be '" + expressionType.getPresentableText() + "'"});
        }
    }

    private void checkOperator(CallInfo<? extends GrBinaryExpression> info) {
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getCall())) {
            return;
        }
        if (GroovyTypeCheckVisitorHelper.isSpockTimesOperator(info.getCall())) {
            return;
        }
        GroovyResolveResult[] results = info.multiResolve();
        GroovyResolveResult resolveResult = info.advancedResolve();
        if (GroovyTypeCheckVisitorHelper.isOperatorWithSimpleTypes(info.getCall(), resolveResult)) {
            return;
        }
        if (!this.checkCannotInferArgumentTypes(info)) {
            return;
        }
        if (resolveResult.getElement() != null) {
            this.checkMethodApplicability(resolveResult, true, info);
        } else if (results.length > 0) {
            for (GroovyResolveResult result : results) {
                if (this.checkMethodApplicability(result, false, info)) continue;
                return;
            }
            this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("method.call.is.ambiguous", new Object[0])});
        }
    }

    private void highlightInapplicableMethodUsage(GroovyResolveResult methodResolveResult, CallInfo info, PsiMethod method) {
        PsiClass containingClass = method instanceof GrGdkMethod ? ((GrGdkMethod)method).getStaticMethod().getContainingClass() : method.getContainingClass();
        PsiType[] argumentTypes = info.getArgumentTypes();
        if (containingClass == null) {
            this.registerCannotApplyError(method.getName(), info);
            return;
        }
        String typesString = GroovyTypeCheckVisitorHelper.buildArgTypesList(argumentTypes);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiClassType containingType = factory.createType(containingClass, methodResolveResult.getSubstitutor());
        String canonicalText = containingType.getInternalCanonicalText();
        String message = method.isConstructor() ? GroovyBundle.message("cannot.apply.constructor", method.getName(), canonicalText, typesString) : GroovyBundle.message("cannot.apply.method1", method.getName(), canonicalText, typesString);
        this.registerError(info.getElementToHighlight(), message, GroovyTypeCheckVisitorHelper.genCastFixes(GrClosureSignatureUtil.createSignature(methodResolveResult), argumentTypes, info.getArgumentList()), ProblemHighlightType.GENERIC_ERROR);
    }

    private void highlightUnknownArgs(CallInfo info) {
        this.registerError(info.getElementToHighlight(), GroovyBundle.message("cannot.infer.argument.types", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.WEAK_WARNING);
    }

    private void processAssignment(PsiType expectedType, GrExpression expression, PsiElement toHighlight) {
        this.processAssignment(expectedType, expression, toHighlight, "cannot.assign", toHighlight, GrTypeConverter.ApplicableTo.ASSIGNMENT);
    }

    private void processAssignment(PsiType expectedType, GrExpression expression, PsiElement toHighlight, @PropertyKey(resourceBundle="org.jetbrains.plugins.groovy.GroovyBundle") String messageKey, PsiElement context, GrTypeConverter.ApplicableTo position) {
        GrListOrMap initializer = GroovyTypeCheckVisitorHelper.getTupleInitializer(expression);
        if (initializer != null) {
            this.processConstructorCall(new GrListOrMapInfo(initializer));
            return;
        }
        if (PsiUtil.isRawClassMemberAccess(expression)) {
            return;
        }
        if (this.checkForImplicitEnumAssigning(expectedType, expression, expression)) {
            return;
        }
        PsiType actualType = expression.getType();
        if (actualType == null) {
            return;
        }
        ConversionResult result = TypesUtil.canAssign(expectedType, actualType, context, position);
        if (result == ConversionResult.OK) {
            return;
        }
        ArrayList fixes = ContainerUtil.newArrayList();
        fixes.add(new GrCastFix(expectedType, expression));
        String varName = GroovyTypeCheckVisitorHelper.getLValueVarName(toHighlight);
        if (varName != null) {
            fixes.add(new GrChangeVariableType(actualType, varName));
        }
        String message = GroovyBundle.message(messageKey, actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError(toHighlight, message, fixes.toArray(new LocalQuickFix[fixes.size()]), result == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private void processAssignment(PsiType lType, PsiType rType, GroovyPsiElement context, PsiElement elementToHighlight) {
        if (rType == null) {
            return;
        }
        ConversionResult result = TypesUtil.canAssign(lType, rType, context, GrTypeConverter.ApplicableTo.ASSIGNMENT);
        this.processResult(result, elementToHighlight, "cannot.assign", lType, rType);
    }

    protected void processAssignmentWithinMultipleAssignment(GrExpression lhs, GrExpression rhs, GrExpression context) {
        PsiType targetType = lhs.getType();
        PsiType actualType = rhs.getType();
        if (targetType == null || actualType == null) {
            return;
        }
        ConversionResult result = TypesUtil.canAssignWithinMultipleAssignment(targetType, actualType, context);
        if (result == ConversionResult.OK) {
            return;
        }
        this.registerError((PsiElement)rhs, GroovyBundle.message("cannot.assign", actualType.getPresentableText(), targetType.getPresentableText()), LocalQuickFix.EMPTY_ARRAY, result == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void processTupleAssignment(GrTupleExpression tupleExpression, GrExpression initializer) {
        GrExpression[] lValues = tupleExpression.getExpressions();
        if (initializer instanceof GrListOrMap) {
            GrExpression[] initializers = ((GrListOrMap)initializer).getInitializers();
            for (int i = 0; i < lValues.length; ++i) {
                GrExpression lValue = lValues[i];
                if (initializers.length > i) {
                    GrExpression rValue = initializers[i];
                    this.processAssignmentWithinMultipleAssignment(lValue, rValue, tupleExpression);
                    continue;
                }
                break;
            }
        } else {
            PsiType type = initializer.getType();
            PsiType rType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
            for (GrExpression lValue : lValues) {
                PsiType lType = lValue.getNominalType();
                if (PsiImplUtil.isSpreadAssignment(lValue)) {
                    PsiType argType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lType, (boolean)false);
                    if (argType != null && rType != null) {
                        this.processAssignment(argType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
                    }
                    return;
                }
                if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
                    return;
                }
                if (lType == null || rType == null) continue;
                this.processAssignment(lType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
            }
        }
    }

    private void processResult(ConversionResult result, PsiElement elementToHighlight, @PropertyKey(resourceBundle="org.jetbrains.plugins.groovy.GroovyBundle") String messageKey, PsiType lType, PsiType rType) {
        if (result == ConversionResult.OK) {
            return;
        }
        this.registerError(elementToHighlight, GroovyBundle.message(messageKey, rType.getPresentableText(), lType.getPresentableText()), LocalQuickFix.EMPTY_ARRAY, result == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void processReturnValue(GrExpression expression, PsiElement context, PsiElement elementToHighlight) {
        if (GroovyTypeCheckVisitorHelper.getTupleInitializer(expression) != null) {
            return;
        }
        PsiType returnType = PsiImplUtil.inferReturnType(expression);
        if (returnType == null || returnType == PsiType.VOID) {
            return;
        }
        this.processAssignment(returnType, expression, elementToHighlight, "cannot.return.type", context, GrTypeConverter.ApplicableTo.RETURN_VALUE);
    }

    private void registerCannotApplyError(String invokedText, CallInfo info) {
        if (info.getArgumentTypes() == null) {
            return;
        }
        String typesString = GroovyTypeCheckVisitorHelper.buildArgTypesList(info.getArgumentTypes());
        this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("cannot.apply.method.or.closure", invokedText, typesString)});
    }

    @Override
    protected void registerError(PsiElement location, String description, LocalQuickFix[] fixes, ProblemHighlightType highlightType) {
        if (PsiUtil.isCompileStatic(location)) {
            if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
                super.registerError(location, description, fixes, highlightType);
            }
        } else if (highlightType == ProblemHighlightType.GENERIC_ERROR) {
            super.registerError(location, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        } else {
            super.registerError(location, description, fixes, highlightType);
        }
    }

    @Override
    public void visitEnumConstant(GrEnumConstant enumConstant) {
        super.visitEnumConstant(enumConstant);
        GrEnumConstantInfo info = new GrEnumConstantInfo(enumConstant);
        this.processConstructorCall(info);
        this.checkNamedArgumentsType(info);
    }

    @Override
    public void visitReturnStatement(GrReturnStatement returnStatement) {
        super.visitReturnStatement(returnStatement);
        GrExpression value = returnStatement.getReturnValue();
        if (value != null) {
            this.processReturnValue(value, returnStatement, returnStatement.getReturnWord());
        }
    }

    @Override
    public void visitThrowStatement(GrThrowStatement throwStatement) {
        super.visitThrowStatement(throwStatement);
        GrExpression exception = throwStatement.getException();
        if (exception == null) {
            return;
        }
        PsiElement throwWord = throwStatement.getFirstChild();
        this.processAssignment((PsiType)PsiType.getJavaLangThrowable((PsiManager)throwStatement.getManager(), (GlobalSearchScope)throwStatement.getResolveScope()), exception, throwWord);
    }

    @Override
    public void visitExpression(GrExpression expression) {
        super.visitExpression(expression);
        if (GroovyTypeCheckVisitorHelper.isImplicitReturnStatement(expression)) {
            this.processReturnValue(expression, expression, expression);
        }
    }

    @Override
    public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
        super.visitMethodCallExpression(methodCallExpression);
        this.checkMethodCall(new GrMethodCallInfo(methodCallExpression));
    }

    @Override
    public void visitNewExpression(GrNewExpression newExpression) {
        super.visitNewExpression(newExpression);
        if (newExpression.getArrayCount() > 0) {
            return;
        }
        GrCodeReferenceElement refElement = newExpression.getReferenceElement();
        if (refElement == null) {
            return;
        }
        GrNewExpressionInfo info = new GrNewExpressionInfo(newExpression);
        this.processConstructorCall(info);
    }

    @Override
    public void visitApplicationStatement(GrApplicationStatement applicationStatement) {
        super.visitApplicationStatement(applicationStatement);
        this.checkMethodCall(new GrMethodCallInfo(applicationStatement));
    }

    @Override
    public void visitAssignmentExpression(GrAssignmentExpression assignment) {
        super.visitAssignmentExpression(assignment);
        GrExpression lValue = assignment.getLValue();
        if (lValue instanceof GrIndexProperty) {
            return;
        }
        if (!PsiUtil.mightBeLValue(lValue)) {
            return;
        }
        IElementType opToken = assignment.getOperationTokenType();
        if (opToken != GroovyTokenTypes.mASSIGN) {
            return;
        }
        GrExpression rValue = assignment.getRValue();
        if (rValue == null) {
            return;
        }
        if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
            return;
        }
        if (lValue instanceof GrTupleExpression) {
            this.processTupleAssignment((GrTupleExpression)lValue, rValue);
        } else {
            PsiType targetType;
            PsiType lValueNominalType = lValue.getNominalType();
            PsiType psiType = targetType = PsiImplUtil.isSpreadAssignment(lValue) ? com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lValueNominalType, (boolean)false) : lValueNominalType;
            if (targetType != null) {
                this.processAssignment(targetType, rValue, lValue, "cannot.assign", assignment, GrTypeConverter.ApplicableTo.ASSIGNMENT);
            }
        }
    }

    @Override
    public void visitBinaryExpression(GrBinaryExpression binary) {
        super.visitBinaryExpression(binary);
        this.checkOperator(new GrBinaryExprInfo(binary));
    }

    @Override
    public void visitCastExpression(GrTypeCastExpression expression) {
        super.visitCastExpression(expression);
        GrExpression operand = expression.getOperand();
        if (operand == null) {
            return;
        }
        PsiType actualType = operand.getType();
        if (actualType == null) {
            return;
        }
        if (expression.getCastTypeElement() == null) {
            return;
        }
        PsiType expectedType = expression.getCastTypeElement().getType();
        ConversionResult result = TypesUtil.canCast(expectedType, actualType, expression);
        if (result == ConversionResult.OK) {
            return;
        }
        ProblemHighlightType highlightType = result == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        String message = GroovyBundle.message("cannot.cast", actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError((PsiElement)expression, highlightType, new Object[]{message});
    }

    @Override
    public void visitIndexProperty(GrIndexProperty expression) {
        super.visitIndexProperty(expression);
        this.checkIndexProperty(new GrIndexPropertyInfo(expression));
    }

    @Override
    public void visitMethod(GrMethod method) {
        super.visitMethod(method);
        PsiTypeParameter[] parameters = method.getTypeParameters();
        HashMap map = ContainerUtil.newHashMap();
        for (PsiTypeParameter parameter : parameters) {
            PsiClassType[] types = parameter.getSuperTypes();
            PsiType bound = PsiIntersectionType.createIntersection((PsiType[])types);
            PsiWildcardType wildcardType = PsiWildcardType.createExtends((PsiManager)method.getManager(), (PsiType)bound);
            map.put(parameter, wildcardType);
        }
        PsiSubstitutor substitutor = PsiSubstitutorImpl.createSubstitutor((Map)map);
        for (GrParameter parameter : method.getParameterList().getParameters()) {
            GrExpression initializer = parameter.getInitializerGroovy();
            if (initializer == null) continue;
            PsiType targetType = parameter.getType();
            this.processAssignment(substitutor.substitute(targetType), initializer, parameter.getNameIdentifierGroovy(), "cannot.assign", method, GrTypeConverter.ApplicableTo.ASSIGNMENT);
        }
    }

    @Override
    public void visitConstructorInvocation(GrConstructorInvocation invocation) {
        super.visitConstructorInvocation(invocation);
        GrConstructorInvocationInfo info = new GrConstructorInvocationInfo(invocation);
        this.processConstructorCall(info);
        this.checkNamedArgumentsType(info);
    }

    @Override
    public void visitParameterList(final GrParameterList parameterList) {
        super.visitParameterList(parameterList);
        PsiElement parent = parameterList.getParent();
        if (!(parent instanceof GrClosableBlock)) {
            return;
        }
        Object[] parameters = parameterList.getParameters();
        if (parameters.length > 0) {
            List<PsiType[]> signatures = ClosureParamsEnhancer.findFittingSignatures((GrClosableBlock)parent);
            final List paramTypes = ContainerUtil.map((Object[])parameters, (Function)new Function<GrParameter, PsiType>(){

                public PsiType fun(GrParameter parameter) {
                    return parameter.getType();
                }
            });
            if (signatures.size() > 1) {
                PsiType[] fittingSignature = (PsiType[])ContainerUtil.find(signatures, (Condition)new Condition<PsiType[]>(){

                    public boolean value(PsiType[] types) {
                        for (int i = 0; i < types.length; ++i) {
                            if (GroovyTypeCheckVisitorHelper.typesAreEqual(types[i], (PsiType)paramTypes.get(i), parameterList)) continue;
                            return false;
                        }
                        return true;
                    }
                });
                if (fittingSignature == null) {
                    this.registerError((PsiElement)parameterList, GroovyInspectionBundle.message("no.applicable.signature.found", new Object[0]), null, ProblemHighlightType.GENERIC_ERROR);
                }
            } else if (signatures.size() == 1) {
                PsiType[] types = signatures.get(0);
                for (int i = 0; i < types.length; ++i) {
                    PsiType actual;
                    PsiType expected;
                    GrTypeElement typeElement = parameters[i].getTypeElementGroovy();
                    if (typeElement == null || GroovyTypeCheckVisitorHelper.typesAreEqual(expected = types[i], actual = (PsiType)paramTypes.get(i), parameterList)) continue;
                    this.registerError((PsiElement)typeElement, GroovyInspectionBundle.message("expected.type.0", expected.getPresentableText()), null, ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }
    }

    @Override
    public void visitForInClause(GrForInClause forInClause) {
        super.visitForInClause(forInClause);
        GrVariable variable = forInClause.getDeclaredVariable();
        GrExpression iterated = forInClause.getIteratedExpression();
        if (variable == null || iterated == null) {
            return;
        }
        PsiType iteratedType = ClosureParameterEnhancer.findTypeForIteration(iterated, (PsiElement)forInClause);
        if (iteratedType == null) {
            return;
        }
        PsiType targetType = variable.getType();
        this.processAssignment(targetType, iteratedType, forInClause, variable.getNameIdentifierGroovy());
    }

    @Override
    public void visitVariable(GrVariable variable) {
        GrExpression initializer;
        super.visitVariable(variable);
        PsiType varType = variable.getType();
        PsiElement parent = variable.getParent();
        if (variable instanceof GrParameter && ((GrParameter)variable).getDeclarationScope() instanceof GrMethod || parent instanceof GrForInClause) {
            return;
        }
        if (parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).isTuple()) {
            GrVariableDeclaration tuple = (GrVariableDeclaration)parent;
            GrExpression initializer2 = tuple.getTupleInitializer();
            if (initializer2 == null) {
                return;
            }
            if (!(initializer2 instanceof GrListOrMap)) {
                PsiType type = initializer2.getType();
                if (type == null) {
                    return;
                }
                PsiType valueType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
                this.processAssignment(varType, valueType, tuple, variable.getNameIdentifierGroovy());
                return;
            }
        }
        if ((initializer = variable.getInitializerGroovy()) == null) {
            return;
        }
        this.processAssignment(varType, initializer, variable.getNameIdentifierGroovy(), "cannot.assign", variable, GrTypeConverter.ApplicableTo.ASSIGNMENT);
    }

    @Override
    protected void registerError(PsiElement location, ProblemHighlightType highlightType, Object ... args) {
        this.registerError(location, (String)args[0], LocalQuickFix.EMPTY_ARRAY, highlightType);
    }
}

