/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.spellchecker;

import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.spellchecker.inspections.CommentSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;

public class GrDocCommentTokenizer
extends Tokenizer<PsiDocComment> {
    private static final Set<String> excludedTags = ContainerUtil.immutableSet((Object[])new String[]{"author", "see", "by", "link"});

    public void tokenize(PsiDocComment comment, TokenConsumer consumer) {
        CommentSplitter splitter = CommentSplitter.getInstance();
        for (PsiElement el : comment.getChildren()) {
            if (el instanceof PsiDocTag) {
                PsiDocTag tag = (PsiDocTag)el;
                if (excludedTags.contains(tag.getName())) continue;
                for (PsiElement data : tag.getDataElements()) {
                    consumer.consumeToken(data, (Splitter)splitter);
                }
                continue;
            }
            consumer.consumeToken(el, (Splitter)splitter);
        }
    }
}

