/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyEmptyTryBlockInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Error handling";
    }

    public String getDisplayName() {
        return "Empty 'try' block";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Empty '#ref' block #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitTryStatement(GrTryCatchStatement tryCatchStatement) {
            super.visitTryStatement(tryCatchStatement);
            GrOpenBlock body = tryCatchStatement.getTryBlock();
            if (body == null || !Visitor.isEmpty(body)) {
                return;
            }
            this.registerError(tryCatchStatement.getFirstChild());
        }

        private static boolean isEmpty(GrOpenBlock body) {
            GrStatement[] statements = body.getStatements();
            return statements.length == 0;
        }
    }
}

