/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;

public class InvalidWriteAccessSearcher {
    public static List<ReadWriteVariableInstruction> findInvalidWriteAccess(Instruction[] flow, Map<String, GrVariable> variables, Set<GrVariable> alreadyInitialized) {
        DFAEngine<MyData> engine = new DFAEngine<MyData>(flow, new MyDFAInstance(), new MySemilattice());
        ArrayList<MyData> dfaResult = engine.performDFAWithTimeout();
        if (dfaResult == null) {
            return null;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (int i = 0; i < flow.length; ++i) {
            Instruction instruction = flow[i];
            if (!(instruction instanceof ReadWriteVariableInstruction) || !((ReadWriteVariableInstruction)instruction).isWrite()) continue;
            MyData initialized = dfaResult.get(i);
            GrVariable var = variables.get(((ReadWriteVariableInstruction)instruction).getVariableName());
            if (alreadyInitialized.contains(var)) {
                if (!initialized.isInitialized(((ReadWriteVariableInstruction)instruction).getVariableName())) continue;
                result.add((ReadWriteVariableInstruction)instruction);
                continue;
            }
            if (!initialized.isOverInitialized(((ReadWriteVariableInstruction)instruction).getVariableName())) continue;
            result.add((ReadWriteVariableInstruction)instruction);
        }
        return result;
    }

    private static class MyData {
        private final Set<String> myInitialized = ContainerUtil.newHashSet();
        private final Set<String> myOverInitialized = ContainerUtil.newHashSet();

        public MyData(List<MyData> ins) {
            for (MyData data : ins) {
                this.myInitialized.addAll(data.myInitialized);
                this.myOverInitialized.addAll(data.myOverInitialized);
            }
        }

        public MyData() {
        }

        public void add(String var) {
            if (!this.myInitialized.add(var)) {
                this.myOverInitialized.add(var);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof MyData && ((Object)this.myInitialized).equals(((MyData)obj).myInitialized) && ((Object)this.myOverInitialized).equals(((MyData)obj).myOverInitialized);
        }

        public boolean isOverInitialized(String var) {
            return this.myOverInitialized.contains(var);
        }

        public boolean isInitialized(String var) {
            return this.myInitialized.contains(var);
        }
    }

    private static class MySemilattice
    implements Semilattice<MyData> {
        private MySemilattice() {
        }

        @Override
        public MyData join(ArrayList<MyData> ins) {
            return new MyData(ins);
        }

        @Override
        public boolean eq(MyData e1, MyData e2) {
            return e1.equals(e2);
        }
    }

    private static class MyDFAInstance
    implements DfaInstance<MyData> {
        private MyDFAInstance() {
        }

        @Override
        public void fun(MyData e, Instruction instruction) {
            if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).isWrite()) {
                e.add(((ReadWriteVariableInstruction)instruction).getVariableName());
            }
        }

        @Override
        public MyData initial() {
            return new MyData();
        }

        @Override
        public boolean isForward() {
            return true;
        }
    }
}

