/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;

public class GroovyNestedConditionalInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Potentially confusing code constructs";
    }

    public String getDisplayName() {
        return "Nested conditional expression";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Nested conditional expression #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(GrConditionalExpression grConditionalExpression) {
            super.visitConditionalExpression(grConditionalExpression);
            GrConditionalExpression containingConditional = (GrConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)grConditionalExpression, GrConditionalExpression.class);
            if (containingConditional == null) {
                return;
            }
            this.registerError(grConditionalExpression);
        }
    }
}

