/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyDivideByZeroInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Probable bugs";
    }

    public String getDisplayName() {
        return "Divide by zero";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Division by zero #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static boolean isZero(GrExpression expression) {
        String text = expression.getText();
        return "0".equals(text) || "0x0".equals(text) || "0X0".equals(text) || "0.0".equals(text) || "0L".equals(text) || "0l".equals(text);
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBinaryExpression(GrBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mDIV.equals(tokenType) && !GroovyTokenTypes.mMOD.equals(tokenType)) {
                return;
            }
            if (!GroovyDivideByZeroInspection.isZero(rhs)) {
                return;
            }
            this.registerError(expression);
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            GrExpression rhs = expression.getRValue();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(GroovyTokenTypes.mDIV_ASSIGN) && !tokenType.equals(GroovyTokenTypes.mMOD_ASSIGN)) {
                return;
            }
            if (!GroovyDivideByZeroInspection.isZero(rhs)) {
                return;
            }
            this.registerError(expression);
        }
    }
}

