/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public abstract class CallInfoBase<T extends GrCall>
implements CallInfo<T> {
    private final T myCall;
    private final PsiType[] myArgTypes;

    protected CallInfoBase(T call) {
        this.myCall = call;
        this.myArgTypes = this.inferArgTypes();
    }

    protected abstract PsiType[] inferArgTypes();

    @Override
    public GrArgumentList getArgumentList() {
        return this.myCall.getArgumentList();
    }

    @Override
    public PsiType[] getArgumentTypes() {
        return this.myArgTypes;
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        return this.myCall.advancedResolve();
    }

    @Override
    public GroovyResolveResult[] multiResolve() {
        return this.myCall.multiResolve(false);
    }

    @Override
    public T getCall() {
        return this.myCall;
    }

    @Override
    public GrExpression[] getExpressionArguments() {
        return this.myCall.getExpressionArguments();
    }

    @Override
    public GrClosableBlock[] getClosureArguments() {
        return this.myCall.getClosureArguments();
    }

    @Override
    public GrNamedArgument[] getNamedArguments() {
        return this.myCall.getNamedArguments();
    }
}

