/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicToolWindowWrapper;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ParamInfo;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DClassElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DItemElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DMethodElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DNamedElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DPropertyElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DRootElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;

@State(name="DynamicElementsStorage", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/dynamic.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class DynamicManagerImpl
extends DynamicManager {
    private final Project myProject;
    private DRootElement myRootElement = new DRootElement();

    public DynamicManagerImpl(final Project project) {
        this.myProject = project;
        StartupManager.getInstance((Project)project).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                if (!DynamicManagerImpl.this.myRootElement.getContainingClasses().isEmpty()) {
                    DynamicToolWindowWrapper.getInstance(project).getToolWindow();
                }
            }
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    public void initComponent() {
    }

    @Override
    public void addProperty(DynamicElementSettings settings) {
        assert (settings != null);
        assert (!settings.isMethod());
        DPropertyElement propertyElement = (DPropertyElement)this.createDynamicElement(settings);
        DClassElement classElement = this.getOrCreateClassElement(this.myProject, settings.getContainingClassName());
        ToolWindow window = DynamicToolWindowWrapper.getInstance(this.myProject).getToolWindow();
        classElement.addProperty(propertyElement);
        this.addItemInTree(classElement, propertyElement, window);
    }

    private void removeItemFromTree(DItemElement itemElement, DClassElement classElement) {
        TreeNode classNode;
        DynamicToolWindowWrapper wrapper = DynamicToolWindowWrapper.getInstance(this.myProject);
        ListTreeTableModelOnColumns model = wrapper.getTreeTableModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)TreeUtil.findNodeWithObject((Object)itemElement, (TreeModel)model, (Object)(classNode = TreeUtil.findNodeWithObject((Object)classElement, (TreeModel)model, (Object)model.getRoot())));
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        DynamicManagerImpl.doRemove(wrapper, node, parent);
    }

    private void removeClassFromTree(DClassElement classElement) {
        DynamicToolWindowWrapper wrapper = DynamicToolWindowWrapper.getInstance(this.myProject);
        ListTreeTableModelOnColumns model = wrapper.getTreeTableModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)TreeUtil.findNodeWithObject((Object)classElement, (TreeModel)model, (Object)model.getRoot());
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        DynamicManagerImpl.doRemove(wrapper, node, parent);
    }

    private static void doRemove(DynamicToolWindowWrapper wrapper, DefaultMutableTreeNode node, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode toSelect = parent.getChildAfter(node) != null || parent.getChildCount() == 1 ? node.getNextNode() : node.getPreviousNode();
        wrapper.removeFromParent(parent, node);
        if (toSelect != null) {
            wrapper.setSelectedNode(toSelect);
        }
    }

    private void addItemInTree(final DClassElement classElement, final DItemElement itemElement, ToolWindow window) {
        final ListTreeTableModelOnColumns myTreeTableModel = DynamicToolWindowWrapper.getInstance(this.myProject).getTreeTableModel();
        window.activate(new Runnable(){

            @Override
            public void run() {
                Object rootObject = myTreeTableModel.getRoot();
                if (!(rootObject instanceof DefaultMutableTreeNode)) {
                    return;
                }
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)rootObject;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(itemElement);
                if (rootNode.getChildCount() > 0) {
                    DefaultMutableTreeNode classNode = (DefaultMutableTreeNode)rootNode.getFirstChild();
                    while (classNode != null) {
                        Object classRow = classNode.getUserObject();
                        if (!(classRow instanceof DClassElement)) {
                            return;
                        }
                        DClassElement otherClassName = (DClassElement)classRow;
                        if (otherClassName.equals(classElement)) {
                            int index = DynamicManagerImpl.getIndexToInsert(classNode, itemElement);
                            classNode.insert(node, index);
                            myTreeTableModel.nodesWereInserted((TreeNode)classNode, new int[]{index});
                            DynamicToolWindowWrapper.getInstance(DynamicManagerImpl.this.myProject).setSelectedNode(node);
                            return;
                        }
                        classNode = (DefaultMutableTreeNode)rootNode.getChildAfter(classNode);
                    }
                }
                int index = DynamicManagerImpl.getIndexToInsert(rootNode, classElement);
                DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(classElement);
                rootNode.insert(classNode, index);
                myTreeTableModel.nodesWereInserted((TreeNode)rootNode, new int[]{index});
                classNode.add(node);
                myTreeTableModel.nodesWereInserted((TreeNode)classNode, new int[]{0});
                DynamicToolWindowWrapper.getInstance(DynamicManagerImpl.this.myProject).setSelectedNode(node);
            }
        }, true);
    }

    private static int getIndexToInsert(DefaultMutableTreeNode parent, DNamedElement namedElement) {
        if (parent.getChildCount() == 0) {
            return 0;
        }
        int res = 0;
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getFirstChild();
        while (child != null) {
            Object childObject = child.getUserObject();
            if (!(childObject instanceof DNamedElement)) {
                return 0;
            }
            String otherName = ((DNamedElement)childObject).getName();
            if (otherName.compareTo(namedElement.getName()) > 0) {
                return res;
            }
            ++res;
            child = (DefaultMutableTreeNode)parent.getChildAfter(child);
        }
        return res;
    }

    @Override
    public void addMethod(DynamicElementSettings settings) {
        if (settings == null) {
            return;
        }
        assert (settings.isMethod());
        DMethodElement methodElement = (DMethodElement)this.createDynamicElement(settings);
        DClassElement classElement = this.getOrCreateClassElement(this.myProject, settings.getContainingClassName());
        ToolWindow window = DynamicToolWindowWrapper.getInstance(this.myProject).getToolWindow();
        classElement.addMethod(methodElement);
        this.addItemInTree(classElement, methodElement, window);
    }

    @Override
    public void removeClassElement(DClassElement classElement) {
        DRootElement rootElement = this.getRootElement();
        rootElement.removeClassElement(classElement.getName());
        this.removeClassFromTree(classElement);
    }

    private void removePropertyElement(DPropertyElement propertyElement) {
        DClassElement classElement = this.getClassElementByItem(propertyElement);
        assert (classElement != null);
        classElement.removeProperty(propertyElement);
    }

    @Override
    public Collection<DPropertyElement> findDynamicPropertiesOfClass(String className) {
        DClassElement classElement = DynamicManagerImpl.findClassElement(this.getRootElement(), className);
        if (classElement != null) {
            return classElement.getProperties();
        }
        return new ArrayList<DPropertyElement>();
    }

    @Override
    public String getPropertyType(String className, String propertyName) {
        DPropertyElement dynamicProperty = DynamicManagerImpl.findConcreteDynamicProperty(this.getRootElement(), className, propertyName);
        if (dynamicProperty == null) {
            return null;
        }
        return dynamicProperty.getType();
    }

    @Override
    public Collection<DClassElement> getAllContainingClasses() {
        DRootElement root = this.getRootElement();
        return root.getContainingClasses();
    }

    @Override
    public DRootElement getRootElement() {
        return this.myRootElement;
    }

    @Override
    public String replaceDynamicPropertyName(String className, String oldPropertyName, String newPropertyName) {
        DClassElement classElement = DynamicManagerImpl.findClassElement(this.getRootElement(), className);
        if (classElement == null) {
            return null;
        }
        DPropertyElement oldPropertyElement = classElement.getPropertyByName(oldPropertyName);
        if (oldPropertyElement == null) {
            return null;
        }
        classElement.removeProperty(oldPropertyElement);
        classElement.addProperty(new DPropertyElement(oldPropertyElement.isStatic(), newPropertyName, oldPropertyElement.getType()));
        this.fireChange();
        DynamicToolWindowWrapper.getInstance(this.getProject()).rebuildTreePanel();
        return newPropertyName;
    }

    @Override
    public String replaceDynamicPropertyType(String className, String propertyName, String oldPropertyType, String newPropertyType) {
        DPropertyElement property = this.findConcreteDynamicProperty(className, propertyName);
        if (property == null) {
            return null;
        }
        property.setType(newPropertyType);
        this.fireChange();
        return newPropertyType;
    }

    private static DMethodElement findConcreteDynamicMethod(DRootElement rootElement, String containingClassName, String methodName, String[] parametersTypes) {
        DClassElement classElement = DynamicManagerImpl.findClassElement(rootElement, containingClassName);
        if (classElement == null) {
            return null;
        }
        return classElement.getMethod(methodName, parametersTypes);
    }

    @Override
    public DMethodElement findConcreteDynamicMethod(String containingClassName, String name, String[] parameterTypes) {
        return DynamicManagerImpl.findConcreteDynamicMethod(this.getRootElement(), containingClassName, name, parameterTypes);
    }

    private void removeMethodElement(DMethodElement methodElement) {
        DClassElement classElement = this.getClassElementByItem(methodElement);
        assert (classElement != null);
        classElement.removeMethod(methodElement);
    }

    @Override
    public void removeItemElement(DItemElement element) {
        DClassElement classElement = this.getClassElementByItem(element);
        if (classElement == null) {
            return;
        }
        if (element instanceof DPropertyElement) {
            this.removePropertyElement((DPropertyElement)element);
        } else if (element instanceof DMethodElement) {
            this.removeMethodElement((DMethodElement)element);
        }
        this.removeItemFromTree(element, classElement);
    }

    @Override
    public void replaceDynamicMethodType(String className, String name, List<ParamInfo> myPairList, String oldType, String newType) {
        DMethodElement method = this.findConcreteDynamicMethod(className, name, QuickfixUtil.getArgumentsTypes(myPairList));
        if (method == null) {
            return;
        }
        method.setType(newType);
        this.fireChange();
    }

    @Override
    public DClassElement getOrCreateClassElement(Project project, String className) {
        DClassElement classElement = DynamicManager.getInstance(this.myProject).getRootElement().getClassElement(className);
        if (classElement == null) {
            return new DClassElement(project, className);
        }
        return classElement;
    }

    @Override
    public DClassElement getClassElementByItem(DItemElement itemElement) {
        Collection<DClassElement> classes = this.getAllContainingClasses();
        for (DClassElement aClass : classes) {
            if (!aClass.containsElement(itemElement)) continue;
            return aClass;
        }
        return null;
    }

    @Override
    public void replaceDynamicMethodName(String className, String oldName, String newName, String[] types) {
        DMethodElement oldMethodElement = this.findConcreteDynamicMethod(className, oldName, types);
        if (oldMethodElement != null) {
            oldMethodElement.setName(newName);
        }
        DynamicToolWindowWrapper.getInstance(this.getProject()).rebuildTreePanel();
        this.fireChange();
    }

    @Override
    public Iterable<PsiMethod> getMethods(final String classQname) {
        DClassElement classElement = this.getRootElement().getClassElement(classQname);
        if (classElement == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.map(classElement.getMethods(), (Function)new Function<DMethodElement, PsiMethod>(){

            public PsiMethod fun(DMethodElement methodElement) {
                return methodElement.getPsi(PsiManager.getInstance((Project)DynamicManagerImpl.this.myProject), classQname);
            }
        });
    }

    @Override
    public Iterable<PsiVariable> getProperties(final String classQname) {
        DClassElement classElement = this.getRootElement().getClassElement(classQname);
        if (classElement == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.map(classElement.getProperties(), (Function)new Function<DPropertyElement, PsiVariable>(){

            public PsiVariable fun(DPropertyElement propertyElement) {
                return propertyElement.getPsi(PsiManager.getInstance((Project)DynamicManagerImpl.this.myProject), classQname);
            }
        });
    }

    @Override
    public void replaceClassName(DClassElement oldClassElement, String newClassName) {
        if (oldClassElement == null) {
            return;
        }
        DRootElement rootElement = this.getRootElement();
        rootElement.removeClassElement(oldClassElement.getName());
        oldClassElement.setName(newClassName);
        rootElement.mergeAddClass(oldClassElement);
        this.fireChange();
    }

    @Override
    public void fireChange() {
        this.fireChangeCodeAnalyze();
    }

    private void fireChangeCodeAnalyze() {
        Editor textEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (textEditor == null) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(textEditor.getDocument());
        if (file == null) {
            return;
        }
        ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)this.myProject).getModificationTracker()).incCounter();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Override
    public DPropertyElement findConcreteDynamicProperty(String containingClassName, String propertyName) {
        return DynamicManagerImpl.findConcreteDynamicProperty(this.getRootElement(), containingClassName, propertyName);
    }

    private static DPropertyElement findConcreteDynamicProperty(DRootElement rootElement, String conatainingClassName, String propertyName) {
        DClassElement classElement = rootElement.getClassElement(conatainingClassName);
        if (classElement == null) {
            return null;
        }
        return classElement.getPropertyByName(propertyName);
    }

    private static DClassElement findClassElement(DRootElement rootElement, String conatainingClassName) {
        return rootElement.getClassElement(conatainingClassName);
    }

    public void disposeComponent() {
    }

    public String getComponentName() {
        return "DynamicManagerImpl";
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public DRootElement getState() {
        return this.myRootElement;
    }

    public void loadState(DRootElement element) {
        this.myRootElement = element;
    }

    @Override
    public DItemElement createDynamicElement(DynamicElementSettings settings) {
        DItemElement itemElement = settings.isMethod() ? new DMethodElement(settings.isStatic(), settings.getName(), settings.getType(), settings.getParams()) : new DPropertyElement(settings.isStatic(), settings.getName(), settings.getType());
        return itemElement;
    }
}

