/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrCreateFromUsageBaseFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;

public class CreateFieldFromUsageFix
extends GrCreateFromUsageBaseFix {
    private final String myReferenceName;

    public CreateFieldFromUsageFix(GrReferenceExpression refExpression, String referenceName) {
        super(refExpression);
        this.myReferenceName = referenceName;
    }

    private String[] generateModifiers(PsiClass targetClass) {
        GrReferenceExpression myRefExpression = this.getRefExpr();
        if (myRefExpression != null && GrStaticChecker.isInStaticContext(myRefExpression, targetClass)) {
            return new String[]{"static"};
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    private TypeConstraint[] calculateTypeConstrains() {
        return GroovyExpectedTypesProvider.calculateTypeConstraints(this.getRefExpr());
    }

    @Override
    public String getText() {
        return GroovyBundle.message("create.field.from.usage", this.myReferenceName);
    }

    @Override
    protected void invokeImpl(Project project, PsiClass targetClass) {
        CreateFieldFix fix = new CreateFieldFix(targetClass);
        fix.doFix(targetClass.getProject(), this.generateModifiers(targetClass), this.myReferenceName, this.calculateTypeConstrains(), this.getRefExpr());
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected boolean canBeTargetClass(PsiClass psiClass) {
        return super.canBeTargetClass(psiClass) && !psiClass.isInterface() && !psiClass.isAnnotationType();
    }
}

