/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

public class CreateFieldFix {
    private final PsiClass myTargetClass;

    protected PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    protected CreateFieldFix(PsiClass targetClass) {
        this.myTargetClass = targetClass;
    }

    public boolean isAvailable() {
        return this.myTargetClass.isValid();
    }

    protected void doFix(Project project, @PsiModifier.ModifierConstant String[] modifiers, String fieldName, TypeConstraint[] typeConstraints, PsiElement context) throws IncorrectOperationException {
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)this.myTargetClass.getLanguage(), (Project)project);
        if (factory == null) {
            return;
        }
        PsiField field = factory.createField(fieldName, (PsiType)PsiType.INT);
        if (this.myTargetClass instanceof GroovyScriptClass) {
            field.getModifierList().addAnnotation("groovy.transform.Field");
        }
        for (String modifier : modifiers) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)modifier, (boolean)true);
        }
        field = CreateFieldFromUsageHelper.insertField((PsiClass)this.myTargetClass, (PsiField)field, (PsiElement)context);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(field.getParent());
        Editor newEditor = IntentionUtils.positionCursor(project, this.myTargetClass.getContainingFile(), (PsiElement)field);
        Template template = CreateFieldFromUsageHelper.setupTemplate((PsiField)field, (Object)typeConstraints, (PsiClass)this.myTargetClass, (Editor)newEditor, (PsiElement)context, (boolean)false);
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(newEditor, template);
    }
}

