/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;

public class AnnotationCollectorChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(AnnotationHolder holder, GrAnnotation annotation) {
        return AnnotationCollectorChecker.isInAliasDeclaration(annotation);
    }

    @Override
    public boolean checkArgumentList(AnnotationHolder holder, GrAnnotation annotation) {
        if (!AnnotationCollectorChecker.isInAliasDeclaration(annotation)) {
            return false;
        }
        PsiClass clazz = (PsiClass)annotation.getClassReference().resolve();
        if (clazz == null) {
            return true;
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        CustomAnnotationChecker.checkAnnotationArguments(holder, clazz, annotation.getClassReference(), attributes, false);
        return true;
    }

    private static boolean isInAliasDeclaration(GrAnnotation annotation) {
        GrAnnotation collector;
        PsiElement parent = annotation.getParent();
        return parent instanceof GrModifierList && (collector = (GrAnnotation)ContainerUtil.find((Object[])((GrModifierList)parent).getRawAnnotations(), (Condition)new Condition<GrAnnotation>(){

            public boolean value(GrAnnotation annotation) {
                return "groovy.transform.AnnotationCollector".equals(annotation.getQualifiedName());
            }
        })) != null;
    }
}

