/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.testframework.Filter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Arrays;

public class StatisticsTable
extends ListTableModel<TestProxy> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.ui.StatisticsTable");
    private TestProxy myTest;
    private JUnitRunningModel myModel;

    public StatisticsTable(ColumnInfo[] columnNames) {
        super(columnNames);
    }

    public void setModel(JUnitRunningModel model) {
        this.myModel = model;
        this.setTest(this.myModel.getRoot());
    }

    public void onSelectionChanged(TestProxy test) {
        this.setTest(test);
    }

    private void setTest(TestProxy test) {
        if (this.myTest == test) {
            return;
        }
        this.updateStatistics(test);
    }

    private void changeTableData() {
        if (this.myTest == null) {
            this.resetTests();
            return;
        }
        this.setItems(new ArrayList<TestProxy>(Arrays.asList(this.myTest.selectChildren(Filter.NO_FILTER))));
    }

    private void resetTests() {
        this.setItems(new ArrayList());
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        LOG.error("value: " + aValue + " row: " + rowIndex + " column: " + columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    private Object testProperty(int columnIndex) {
        if (columnIndex == 0) {
            return ExecutionBundle.message((String)"junit.runing.info.total.label", (Object[])new Object[0]);
        }
        return this.getAspectOf(columnIndex, (Object)this.myTest);
    }

    public TestProxy getTestAt(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.getItems().size()) {
            return null;
        }
        return (TestProxy)((Object)this.getItems().get(rowIndex));
    }

    public int getIndexOf(Object test) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            Object child = this.getItems().get(i);
            if (child != test) continue;
            return i;
        }
        return -1;
    }

    public void updateStatistics(TestProxy currentTest) {
        this.myTest = currentTest;
        this.changeTableData();
    }
}

