/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.inspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import org.jdom.Element;

public class JUnitEntryPoint
extends EntryPoint {
    public boolean ADD_JUNIT_TO_ENTRIES = true;

    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.dead.code.option2", (Object[])new Object[0]);
    }

    public boolean isEntryPoint(RefElement refElement, PsiElement psiElement) {
        return this.isEntryPoint(psiElement);
    }

    public boolean isEntryPoint(PsiElement psiElement) {
        if (this.ADD_JUNIT_TO_ENTRIES) {
            if (psiElement instanceof PsiClass) {
                PsiClass aClass = (PsiClass)psiElement;
                if (JUnitUtil.isTestClass((PsiClass)aClass, (boolean)false, (boolean)true)) {
                    if (!PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true, (boolean)true)) {
                        PsiClass topLevelClass = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)aClass, PsiClass.class);
                        if (topLevelClass != null && PsiClassUtil.isRunnableClass((PsiClass)topLevelClass, (boolean)true, (boolean)true)) {
                            return true;
                        }
                        CommonProcessors.FindProcessor<PsiClass> findProcessor = new CommonProcessors.FindProcessor<PsiClass>(){

                            protected boolean accept(PsiClass psiClass) {
                                return !psiClass.hasModifierProperty("abstract");
                            }
                        };
                        return !ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)findProcessor) && findProcessor.isFound();
                    }
                    return true;
                }
            } else if (psiElement instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)psiElement;
                if (method.isConstructor() && method.getParameterList().getParametersCount() == 0) {
                    return JUnitUtil.isTestClass((PsiClass)method.getContainingClass());
                }
                if (JUnitUtil.isTestMethodOrConfig((PsiMethod)method)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSelected() {
        return this.ADD_JUNIT_TO_ENTRIES;
    }

    public void setSelected(boolean selected) {
        this.ADD_JUNIT_TO_ENTRIES = selected;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.ADD_JUNIT_TO_ENTRIES) {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        }
    }

    public String[] getIgnoreAnnotations() {
        return new String[]{"org.junit.Rule", "org.mockito.Mock", "org.mockito.Spy", "org.mockito.Captor", "org.mockito.InjectMocks", "org.junit.ClassRule", "org.junit.experimental.theories.DataPoint"};
    }
}

