/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitProcessHandler;
import com.intellij.execution.junit.TestCategory;
import com.intellij.execution.junit.TestClass;
import com.intellij.execution.junit.TestDirectory;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.segments.DeferredActionsQueue;
import com.intellij.execution.junit2.segments.DeferredActionsQueueImpl;
import com.intellij.execution.junit2.segments.DispatchListener;
import com.intellij.execution.junit2.segments.Extractor;
import com.intellij.execution.junit2.ui.JUnitTreeConsoleView;
import com.intellij.execution.junit2.ui.TestsPacketsReceiver;
import com.intellij.execution.junit2.ui.actions.RerunFailedTestsAction;
import com.intellij.execution.junit2.ui.model.CompletionEvent;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.RootTestInfo;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.rt.execution.CommandLineWrapper;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageTypes;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public abstract class TestObject
implements JavaCommandLine {
    protected static final Logger LOG = Logger.getInstance(TestObject.class);
    private static final String MESSAGE = ExecutionBundle.message((String)"configuration.not.speficied.message", (Object[])new Object[0]);
    private static final String JUNIT_TEST_FRAMEWORK_NAME = "JUnit";
    protected JavaParameters myJavaParameters;
    protected final JUnitConfiguration myConfiguration;
    protected final ExecutionEnvironment myEnvironment;
    protected File myTempFile = null;
    protected File myWorkingDirsFile = null;
    public File myListenersFile;
    private static final TestObject NOT_CONFIGURED = new TestObject(null, null){

        @Override
        public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
            return null;
        }

        @Override
        public String suggestActionName() {
            throw new RuntimeException(String.valueOf((Object)this.myConfiguration));
        }

        @Override
        public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
            return false;
        }

        @Override
        public void checkConfiguration() throws RuntimeConfigurationException {
            throw new RuntimeConfigurationError(MESSAGE);
        }

        @Override
        public JavaParameters getJavaParameters() throws ExecutionException {
            throw new ExecutionException(MESSAGE);
        }

        @Override
        protected void initialize() throws ExecutionException {
            throw new ExecutionException(MESSAGE);
        }
    };

    public static TestObject fromString(String id, JUnitConfiguration configuration, ExecutionEnvironment environment) {
        if ("method".equals(id)) {
            return new TestMethod(configuration, environment);
        }
        if ("class".equals(id)) {
            return new TestClass(configuration, environment);
        }
        if ("package".equals(id)) {
            return new TestPackage(configuration, environment);
        }
        if ("directory".equals(id)) {
            return new TestDirectory(configuration, environment);
        }
        if ("category".equals(id)) {
            return new TestCategory(configuration, environment);
        }
        if ("pattern".equals(id)) {
            return new TestsPattern(configuration, environment);
        }
        return NOT_CONFIGURED;
    }

    public Module[] getModulesToCompile() {
        SourceScope sourceScope = this.getSourceScope();
        return sourceScope != null ? sourceScope.getModulesToCompile() : Module.EMPTY_ARRAY;
    }

    protected TestObject(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        this.myConfiguration = configuration;
        this.myEnvironment = environment;
    }

    public abstract String suggestActionName();

    public RunnerSettings getRunnerSettings() {
        return this.myEnvironment.getRunnerSettings();
    }

    public abstract RefactoringElementListener getListener(PsiElement var1, JUnitConfiguration var2);

    public abstract boolean isConfiguredByElement(JUnitConfiguration var1, PsiClass var2, PsiMethod var3, PsiPackage var4, PsiDirectory var5);

    protected void configureModule(JavaParameters parameters, RunConfigurationModule configurationModule, String mainClassName) throws CantRunException {
        int classPathType = JavaParametersUtil.getClasspathType((RunConfigurationModule)configurationModule, (String)mainClassName, (boolean)true);
        JavaParametersUtil.configureModule((RunConfigurationModule)configurationModule, (JavaParameters)parameters, (int)classPathType, this.myConfiguration.isAlternativeJrePathEnabled() ? this.myConfiguration.getAlternativeJrePath() : null);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.myConfiguration);
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.myConfiguration, (Project)this.myConfiguration.getProject(), (Module)((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getModule());
    }

    public SourceScope getSourceScope() {
        return SourceScope.modulesWithDependencies((Module[])this.myConfiguration.getModules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws ExecutionException {
        String parameters = this.myConfiguration.getProgramParameters();
        this.myConfiguration.getPersistentData().setProgramParameters(null);
        try {
            JavaParametersUtil.configureConfiguration((SimpleJavaParameters)this.myJavaParameters, (CommonJavaRunConfigurationParameters)this.myConfiguration);
        }
        finally {
            this.myConfiguration.getPersistentData().setProgramParameters(parameters);
        }
        this.myJavaParameters.setMainClass("com.intellij.rt.execution.junit.JUnitStarter");
        Module module = ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getModule();
        if (this.myJavaParameters.getJdk() == null) {
            this.myJavaParameters.setJdk(module != null ? ModuleRootManager.getInstance((Module)module).getSdk() : ProjectRootManager.getInstance((Project)this.myEnvironment.getProject()).getProjectSdk());
        }
        this.configureAdditionalClasspath(this.myJavaParameters);
        this.myJavaParameters.getProgramParametersList().add("-ideVersion5");
        if (!StringUtil.isEmptyOrSpaces((String)parameters)) {
            this.myJavaParameters.getProgramParametersList().add("@name" + parameters);
        }
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
            ext.updateJavaParameters((RunConfigurationBase)this.myConfiguration, this.myJavaParameters, this.getRunnerSettings());
        }
        Object[] listeners = Extensions.getExtensions((String)"com.intellij.junitListener");
        StringBuilder buf = new StringBuilder();
        for (Object listener : listeners) {
            boolean enabled = true;
            for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
                if (!ext.isListenerDisabled((RunConfigurationBase)this.myConfiguration, listener, this.getRunnerSettings())) continue;
                enabled = false;
                break;
            }
            if (!enabled) continue;
            Class<?> classListener = listener.getClass();
            buf.append(classListener.getName()).append("\n");
            this.myJavaParameters.getClassPath().add(PathUtil.getJarPathForClass(classListener));
        }
        if (buf.length() > 0) {
            try {
                this.myListenersFile = FileUtil.createTempFile((String)"junit_listeners_", (String)"");
                this.myListenersFile.deleteOnExit();
                this.myJavaParameters.getProgramParametersList().add("@@" + this.myListenersFile.getPath());
                FileUtil.writeToFile((File)this.myListenersFile, (byte[])buf.toString().getBytes(CharsetToolkit.UTF8_CHARSET));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void configureAdditionalClasspath(JavaParameters javaParameters) {
        javaParameters.getClassPath().add(JavaSdkUtil.getIdeaRtJarPath());
        javaParameters.getClassPath().add(PathUtil.getJarPathForClass(JUnitStarter.class));
        if (Registry.is((String)"junit_sm_runner")) {
            javaParameters.getClassPath().add(PathUtil.getJarPathForClass(ServiceMessageTypes.class));
        }
    }

    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myJavaParameters == null) {
            Object[] patchers;
            this.myJavaParameters = new JavaParameters();
            this.initialize();
            Module module = ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getModule();
            for (Object patcher : patchers = Extensions.getExtensions((String)"com.intellij.junitPatcher")) {
                ((JUnitPatcher)patcher).patchJavaParameters(module, this.myJavaParameters);
            }
        }
        return this.myJavaParameters;
    }

    public ExecutionResult execute(Executor executor, ProgramRunner runner) throws ExecutionException {
        boolean smRunner = Registry.is((String)"junit_sm_runner");
        if (smRunner) {
            this.myJavaParameters.getVMParametersList().add("-Didea.junit.sm_runner");
        }
        final JUnitProcessHandler handler = this.createHandler(executor);
        RunnerSettings runnerSettings = this.getRunnerSettings();
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)handler, runnerSettings);
        if (smRunner) {
            return this.useSmRunner(executor, handler);
        }
        final TestProxy unboundOutputRoot = new TestProxy(new RootTestInfo());
        final JUnitConsoleProperties consoleProperties = new JUnitConsoleProperties(this.myConfiguration, executor);
        final JUnitTreeConsoleView consoleView = new JUnitTreeConsoleView(consoleProperties, this.myEnvironment, unboundOutputRoot);
        Disposer.register((Disposable)this.myConfiguration.getProject(), (Disposable)consoleView);
        consoleView.initUI();
        consoleView.attachToProcess((ProcessHandler)handler);
        unboundOutputRoot.setPrinter((Printer)consoleView.getPrinter());
        Disposer.register((Disposable)consoleView, (Disposable)unboundOutputRoot);
        final TestsPacketsReceiver packetsReceiver = new TestsPacketsReceiver(consoleView, unboundOutputRoot){

            @Override
            public synchronized void notifyStart(TestProxy root) {
                JUnitRunningModel model;
                if (!this.isRunning()) {
                    return;
                }
                super.notifyStart(root);
                unboundOutputRoot.addChild(root);
                if (TestObject.this.myConfiguration.isSaveOutputToFile()) {
                    unboundOutputRoot.setOutputFilePath(TestObject.this.myConfiguration.getOutputFilePath());
                }
                if ((model = this.getModel()) != null) {
                    handler.getOut().setDispatchListener((DispatchListener)model.getNotifier());
                    Disposer.register((Disposable)model, (Disposable)new Disposable(){

                        public void dispose() {
                            handler.getOut().setDispatchListener(DispatchListener.DEAF);
                        }
                    });
                    consoleView.attachToModel(model);
                }
            }
        };
        Disposer.register((Disposable)consoleView, (Disposable)packetsReceiver);
        DeferredActionsQueueImpl queue = new DeferredActionsQueueImpl();
        handler.getOut().setPacketDispatcher((PacketProcessor)packetsReceiver, (DeferredActionsQueue)queue);
        handler.getErr().setPacketDispatcher((PacketProcessor)packetsReceiver, (DeferredActionsQueue)queue);
        handler.addProcessListener((ProcessListener)new ProcessAdapter((DeferredActionsQueue)queue){
            private boolean myStarted = false;
            final /* synthetic */ DeferredActionsQueue val$queue;
            {
                this.val$queue = deferredActionsQueue;
            }

            public void startNotified(ProcessEvent event) {
                this.myStarted = true;
            }

            public void processTerminated(ProcessEvent event) {
                handler.removeProcessListener((ProcessListener)this);
                if (TestObject.this.myTempFile != null) {
                    FileUtil.delete((File)TestObject.this.myTempFile);
                }
                if (TestObject.this.myListenersFile != null) {
                    FileUtil.delete((File)TestObject.this.myListenersFile);
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        unboundOutputRoot.flush();
                        packetsReceiver.checkTerminated();
                        JUnitRunningModel model = packetsReceiver.getModel();
                        TestObject.this.notifyByBalloon(model, myStarted, consoleProperties);
                    }
                };
                handler.getOut().addRequest(runnable, this.val$queue);
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                final String text = event.getText();
                final ConsoleViewContentType consoleViewType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                Printable printable = new Printable(){

                    public void printOn(Printer printer) {
                        printer.print(text, consoleViewType);
                    }
                };
                Extractor extractor = consoleViewType == ConsoleViewContentType.ERROR_OUTPUT || consoleViewType == ConsoleViewContentType.SYSTEM_OUTPUT ? handler.getErr() : handler.getOut();
                extractor.getEventsDispatcher().processOutput(printable);
            }
        });
        RerunFailedTestsAction rerunFailedTestsAction = new RerunFailedTestsAction((ComponentContainer)consoleView, (TestConsoleProperties)consoleProperties);
        rerunFailedTestsAction.setModelProvider((Getter)new Getter<TestFrameworkRunningModel>(){

            public TestFrameworkRunningModel get() {
                return packetsReceiver.getModel();
            }
        });
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)handler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        return result;
    }

    private ExecutionResult useSmRunner(Executor executor, JUnitProcessHandler handler) {
        SMTRunnerConsoleProperties testConsoleProperties = new SMTRunnerConsoleProperties((RunConfiguration)this.myConfiguration, JUNIT_TEST_FRAMEWORK_NAME, executor);
        testConsoleProperties.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsoleWithCustomLocator((String)JUNIT_TEST_FRAMEWORK_NAME, (TestConsoleProperties)testConsoleProperties, (ExecutionEnvironment)this.myEnvironment, null);
        Disposer.register((Disposable)this.myConfiguration.getProject(), (Disposable)consoleView);
        consoleView.attachToProcess((ProcessHandler)handler);
        RerunFailedTestsAction rerunFailedTestsAction = new RerunFailedTestsAction((ComponentContainer)consoleView, (TestConsoleProperties)testConsoleProperties);
        rerunFailedTestsAction.setModelProvider((Getter)new Getter<TestFrameworkRunningModel>((ConsoleView)consoleView){
            final /* synthetic */ ConsoleView val$consoleView;
            {
                this.val$consoleView = consoleView;
            }

            public TestFrameworkRunningModel get() {
                return ((SMTRunnerConsoleView)this.val$consoleView).getResultsViewer();
            }
        });
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)handler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        return result;
    }

    protected void notifyByBalloon(JUnitRunningModel model, boolean started, JUnitConsoleProperties consoleProperties) {
        CompletionEvent done;
        String comment = model != null ? ((done = model.getProgress().getDone()) != null ? done.getComment() : null) : null;
        TestsUIUtil.notifyByBalloon((Project)this.myEnvironment.getProject(), (boolean)started, (AbstractTestProxy)(model != null ? model.getRoot() : null), (TestConsoleProperties)consoleProperties, (String)comment);
    }

    protected JUnitProcessHandler createHandler(Executor executor) throws ExecutionException {
        this.appendForkInfo(executor);
        return JUnitProcessHandler.runCommandLine((GeneralCommandLine)CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)this.myJavaParameters, (Project)this.myEnvironment.getProject(), (boolean)true));
    }

    private boolean forkPerModule() {
        String workingDirectory = this.myConfiguration.getWorkingDirectory();
        return "package".equals(this.myConfiguration.getPersistentData().TEST_OBJECT) && this.myConfiguration.getPersistentData().getScope() != TestSearchScope.SINGLE_MODULE && "$MODULE_DIR$".equals(workingDirectory) && this.spansMultipleModules();
    }

    private boolean spansMultipleModules() {
        SourceScope sourceScope;
        TestSearchScope scope;
        Project project;
        PsiPackage aPackage;
        String qualifiedName = this.myConfiguration.getPackage();
        if (qualifiedName != null && (aPackage = JavaPsiFacade.getInstance((Project)(project = this.myConfiguration.getProject())).findPackage(qualifiedName)) != null && (scope = this.myConfiguration.getPersistentData().getScope()) != null && (sourceScope = scope.getSourceScope((ModuleBasedConfiguration)this.myConfiguration)) != null) {
            GlobalSearchScope configurationSearchScope = GlobalSearchScopesCore.projectTestScope((Project)project).intersectWith(sourceScope.getGlobalSearchScope());
            PsiDirectory[] directories = aPackage.getDirectories(configurationSearchScope);
            return directories.length > 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendForkInfo(Executor executor) throws ExecutionException {
        JavaParameters javaParameters;
        Sdk jdk;
        String forkMode = this.myConfiguration.getForkMode();
        if (Comparing.strEqual((String)forkMode, (String)"none")) {
            if (!this.forkPerModule()) return;
            if (this.getRunnerSettings() != null) {
                String actionName = UIUtil.removeMnemonic((String)executor.getStartActionText());
                throw new CantRunException("'" + actionName + "' is disabled when per-module working directory is configured.<br/>" + "Please specify single working directory, or change test scope to single module.");
            }
        } else if (this.getRunnerSettings() != null) {
            String actionName = executor.getActionName();
            throw new CantRunException(actionName + " is disabled in fork mode.<br/>Please change fork mode to &lt;none&gt; to " + actionName.toLowerCase(Locale.ENGLISH) + ".");
        }
        if ((jdk = (javaParameters = this.getJavaParameters()).getJdk()) == null) {
            throw new ExecutionException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
        }
        try {
            File tempFile = FileUtil.createTempFile((String)"command.line", (String)"", (boolean)true);
            PrintWriter writer = new PrintWriter(tempFile, "UTF-8");
            try {
                if (JdkUtil.useDynamicClasspath((Project)this.myConfiguration.getProject())) {
                    String utilRtPath;
                    String classpath = PathUtil.getJarPathForClass(CommandLineWrapper.class);
                    if (!classpath.equals(utilRtPath = PathUtil.getJarPathForClass(StringUtilRt.class))) {
                        classpath = classpath + File.pathSeparator + utilRtPath;
                    }
                    writer.println(classpath);
                } else {
                    writer.println("");
                }
                writer.println(((JavaSdkType)jdk.getSdkType()).getVMExecutablePath(jdk));
                for (String vmParameter : javaParameters.getVMParametersList().getList()) {
                    writer.println(vmParameter);
                }
            }
            finally {
                writer.close();
            }
            this.myJavaParameters.getProgramParametersList().add("@@@" + forkMode + ',' + tempFile.getAbsolutePath());
            return;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void addClassesListToJavaParameters(Collection<? extends T> elements, Function<T, String> nameFunction, String packageName, boolean createTempFile, boolean junit4) throws CantRunException {
        block18: {
            try {
                if (createTempFile) {
                    this.createTempFiles();
                }
                TreeMap<Module, ArrayList<String>> perModule = this.forkPerModule() ? new TreeMap<Module, ArrayList<String>>(new Comparator<Module>(){

                    @Override
                    public int compare(Module o1, Module o2) {
                        return StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);
                    }
                }) : null;
                ArrayList<String> testNames = new ArrayList<String>();
                for (T element : elements) {
                    String name = (String)nameFunction.fun(element);
                    if (name == null) {
                        LOG.error("invalid element " + element);
                        return;
                    }
                    if (perModule != null && element instanceof PsiElement) {
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)element));
                        if (module == null) continue;
                        ArrayList<String> list = (ArrayList<String>)perModule.get(module);
                        if (list == null) {
                            list = new ArrayList<String>();
                            perModule.put(module, list);
                        }
                        list.add(name);
                        continue;
                    }
                    testNames.add(name);
                }
                JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
                if (perModule != null) {
                    for (List perModuleClasses : perModule.values()) {
                        Collections.sort(perModuleClasses);
                        testNames.addAll(perModuleClasses);
                    }
                } else if ("package".equals(data.TEST_OBJECT)) {
                    Collections.sort(testNames);
                }
                String category = "category".equals(data.TEST_OBJECT) ? data.getCategory() : "";
                JUnitStarter.printClassesList(testNames, (String)packageName, (String)category, (File)this.myTempFile);
                if (perModule == null || perModule.size() <= 1) break block18;
                String classpath = this.myConfiguration.getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT ? null : this.myJavaParameters.getClassPath().getPathsString();
                PrintWriter wWriter = new PrintWriter(this.myWorkingDirsFile, "UTF-8");
                try {
                    wWriter.println(packageName);
                    for (Module module : perModule.keySet()) {
                        String moduleDir = PathMacroUtil.getModuleDir((String)module.getModuleFilePath());
                        wWriter.println(moduleDir);
                        if (classpath == null) {
                            JavaParameters parameters = new JavaParameters();
                            this.configureAdditionalClasspath(parameters);
                            JavaParametersUtil.configureModule((Module)module, (JavaParameters)parameters, (int)7, this.myConfiguration.isAlternativeJrePathEnabled() ? this.myConfiguration.getAlternativeJrePath() : null);
                            wWriter.println(parameters.getClassPath().getPathsString());
                        } else {
                            wWriter.println(classpath);
                        }
                        List classNames = (List)perModule.get(module);
                        wWriter.println(classNames.size());
                        for (String className : classNames) {
                            wWriter.println(className);
                        }
                    }
                }
                finally {
                    wWriter.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void createTempFiles() throws IOException {
        this.myTempFile = FileUtil.createTempFile((String)"idea_junit", (String)".tmp");
        this.myTempFile.deleteOnExit();
        this.myJavaParameters.getProgramParametersList().add("@" + this.myTempFile.getAbsolutePath());
        this.myWorkingDirsFile = FileUtil.createTempFile((String)"idea_working_dirs_junit", (String)".tmp");
        this.myWorkingDirsFile.deleteOnExit();
        this.myJavaParameters.getProgramParametersList().add("@w@" + this.myWorkingDirsFile.getAbsolutePath());
    }

    public void clear() {
        this.myJavaParameters = null;
    }
}

