/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.junit2.info.TestInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.LinkedHashSet;

public class TestMethods
extends TestMethod {
    private static final Logger LOG = Logger.getInstance(TestMethods.class);
    private final Collection<AbstractTestProxy> myFailedTests;

    public TestMethods(JUnitConfiguration configuration, ExecutionEnvironment environment, Collection<AbstractTestProxy> failedTests) {
        super(configuration, environment);
        this.myFailedTests = failedTests;
    }

    @Override
    protected void initialize() throws ExecutionException {
        this.defaultInitialize();
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        RunConfigurationModule module = this.myConfiguration.getConfigurationModule();
        final Project project = module.getProject();
        final ExecutionException[] exception = new ExecutionException[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    TestMethods.this.myConfiguration.configureClasspath(TestMethods.this.myJavaParameters);
                }
                catch (CantRunException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        LinkedHashSet<TestInfo> methods = new LinkedHashSet<TestInfo>();
        final GlobalSearchScope searchScope = ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getSearchScope();
        for (AbstractTestProxy failedTest : this.myFailedTests) {
            PsiElement element;
            Location location = failedTest.getLocation(project, searchScope);
            if (location instanceof PsiMemberParameterizedLocation && (element = location.getPsiElement()) instanceof PsiMethod) {
                location = MethodLocation.elementInClass((PsiMethod)((PsiMethod)element), (PsiClass)((PsiMemberParameterizedLocation)location).getContainingClass());
            }
            if (!(location instanceof MethodLocation)) continue;
            PsiElement psiElement = location.getPsiElement();
            LOG.assertTrue(psiElement instanceof PsiMethod);
            methods.add(((TestProxy)failedTest).getInfo());
        }
        this.addClassesListToJavaParameters(methods, new Function<TestInfo, String>(){

            public String fun(TestInfo testInfo) {
                if (testInfo != null) {
                    MethodLocation location = (MethodLocation)testInfo.getLocation(project, searchScope);
                    LOG.assertTrue(location != null);
                    return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)location.getContainingClass()) + "," + testInfo.getName();
                }
                return null;
            }
        }, data.getPackageName(), true, false);
    }

    @Override
    public String suggestActionName() {
        return ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]);
    }
}

