/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.PatternConfigurationDelegate;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.Set;

public class PatternConfigurationProducer
extends JUnitConfigurationProducer {
    private static PatternConfigurationDelegate ourDelegate = new PatternConfigurationDelegate(){

        protected boolean isTestClass(PsiClass psiClass) {
            return JUnitUtil.isTestClass((PsiClass)psiClass);
        }

        protected boolean isTestMethod(boolean checkAbstract, PsiElement psiElement) {
            return JUnitUtil.getTestMethod((PsiElement)psiElement, (boolean)checkAbstract) != null;
        }
    };

    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement element = ourDelegate.checkPatterns(context, classes);
        if (element == null) {
            return false;
        }
        sourceElement.set((Object)element);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setPatterns(classes);
        data.TEST_OBJECT = "pattern";
        data.setScope(this.setupPackageConfiguration(context, configuration, data.getScope()));
        configuration.setGeneratedName();
        return true;
    }

    protected Module findModule(JUnitConfiguration configuration, Module contextModule) {
        Set<String> patterns = configuration.getPersistentData().getPatterns();
        return PatternConfigurationProducer.findModule(configuration, contextModule, patterns);
    }

    @Override
    public boolean isConfigurationFromContext(JUnitConfiguration unitConfiguration, ConfigurationContext context) {
        Set<String> patterns;
        TestObject testobject = unitConfiguration.getTestObject();
        return testobject instanceof TestsPattern && ourDelegate.isConfiguredFromContext(context, patterns = unitConfiguration.getPersistentData().getPatterns());
    }

    public static Module findModule(ModuleBasedConfiguration configuration, Module contextModule, Set<String> patterns) {
        return ourDelegate.findModule(configuration, contextModule, patterns);
    }

    public static boolean isMultipleElementsSelected(ConfigurationContext context) {
        return ourDelegate.isMultipleElementsSelected(context);
    }

    public static Set<PsiElement> collectTestMembers(PsiElement[] elements, boolean checkAbstract) {
        return ourDelegate.collectTestMembers(elements, checkAbstract);
    }
}

