/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.lang.properties.references.I18nizeQuickFixModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;

public class CreatePropertyFix
implements IntentionAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.i18n.I18nizeQuickFix");
    private final PsiAnchor myElement;
    private final String myKey;
    private final List<PropertiesFile> myPropertiesFiles;
    public static final String NAME = PropertiesBundle.message("create.property.quickfix.text", new Object[0]);

    public CreatePropertyFix() {
        this(null, null, null);
    }

    public CreatePropertyFix(PsiElement element, String key, List<PropertiesFile> propertiesFiles) {
        this.myElement = element == null ? null : PsiAnchor.create((PsiElement)element);
        this.myKey = key;
        this.myPropertiesFiles = propertiesFiles;
    }

    public String getName() {
        return NAME;
    }

    public String getFamilyName() {
        return this.getText();
    }

    public void applyFix(Project project, ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        if (this.isAvailable(project, null, null)) {
            this.invoke(project, null, psiElement.getContainingFile());
        }
    }

    public String getText() {
        return NAME;
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        return this.myElement != null && this.myElement.retrieve() != null;
    }

    public void invoke(Project project, Editor editor, PsiFile file) {
        this.invokeAction(project, file, this.myElement.retrieve(), this.myKey, this.myPropertiesFiles);
    }

    private Couple<String> invokeAction(Project project, PsiFile file, PsiElement psiElement, String suggestedKey, final List<PropertiesFile> propertiesFiles) {
        final I18nizeQuickFixDialog.DialogCustomization dialogCustomization = CreatePropertyFix.createDefaultCustomization(suggestedKey, propertiesFiles);
        I18nizeQuickFixModel model = ApplicationManager.getApplication().isUnitTestMode() ? new I18nizeQuickFixModel(){

            @Override
            public String getValue() {
                return "";
            }

            @Override
            public String getKey() {
                return dialogCustomization.getSuggestedName();
            }

            @Override
            public boolean hasValidData() {
                return true;
            }

            @Override
            public Collection<PropertiesFile> getAllPropertiesFiles() {
                return propertiesFiles;
            }
        } : new I18nizeQuickFixDialog(project, file, NAME, dialogCustomization);
        return this.doAction(project, psiElement, model);
    }

    protected static I18nizeQuickFixDialog.DialogCustomization createDefaultCustomization(String suggestedKey, List<PropertiesFile> propertiesFiles) {
        return new I18nizeQuickFixDialog.DialogCustomization(NAME, false, true, propertiesFiles, suggestedKey == null ? "" : suggestedKey);
    }

    protected Couple<String> doAction(Project project, PsiElement psiElement, I18nizeQuickFixModel model) {
        if (!model.hasValidData()) {
            return null;
        }
        String key = model.getKey();
        String value = model.getValue();
        Collection<PropertiesFile> selectedPropertiesFiles = model.getAllPropertiesFiles();
        CreatePropertyFix.createProperty(project, psiElement, selectedPropertiesFiles, key, value);
        return Couple.of((Object)key, (Object)value);
    }

    public static void createProperty(final Project project, PsiElement psiElement, final Collection<PropertiesFile> selectedPropertiesFiles, final String key, final String value) {
        for (PropertiesFile selectedFile : selectedPropertiesFiles) {
            if (FileModificationService.getInstance().prepareFileForWrite(selectedFile.getContainingFile())) continue;
            return;
        }
        UndoUtil.markPsiFileForUndo((PsiFile)psiElement.getContainingFile());
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            I18nUtil.createProperty(project, selectedPropertiesFiles, key, value);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }, CodeInsightBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

