/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.structureView.GroupByWordPrefixes;
import com.intellij.lang.properties.structureView.PropertiesSeparatorManager;

public class ResourceBundleStructureViewModel
implements PropertiesGroupingStructureViewModel,
StructureViewModel.ExpandInfoProvider {
    private final ResourceBundle myResourceBundle;
    private final GroupByWordPrefixes myByWordPrefixesGrouper;
    private final StructureViewTreeElement myRoot;

    public ResourceBundleStructureViewModel(ResourceBundle root) {
        this.myResourceBundle = root;
        String separator = PropertiesSeparatorManager.getInstance(root.getProject()).getSeparator(this.myResourceBundle);
        this.myByWordPrefixesGrouper = new GroupByWordPrefixes(separator);
        this.myRoot = new ResourceBundleFileStructureViewElement(this.myResourceBundle);
    }

    @Override
    public void setSeparator(String separator) {
        this.myByWordPrefixesGrouper.setSeparator(separator);
        PropertiesSeparatorManager.getInstance(this.myResourceBundle.getProject()).setSeparator(this.myResourceBundle, separator);
    }

    @Override
    public String getSeparator() {
        return this.myByWordPrefixesGrouper.getSeparator();
    }

    public StructureViewTreeElement getRoot() {
        return this.myRoot;
    }

    public Grouper[] getGroupers() {
        return new Grouper[]{this.myByWordPrefixesGrouper};
    }

    public Sorter[] getSorters() {
        return new Sorter[]{Sorter.ALPHA_SORTER};
    }

    public Filter[] getFilters() {
        return Filter.EMPTY_ARRAY;
    }

    public Object getCurrentEditorElement() {
        return null;
    }

    public void addEditorPositionListener(FileEditorPositionListener listener) {
    }

    public void removeEditorPositionListener(FileEditorPositionListener listener) {
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    public void dispose() {
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return element instanceof ResourceBundlePropertyStructureViewElement;
    }

    public boolean isAutoExpand(StructureViewTreeElement element) {
        return this.getRoot() == element;
    }

    public boolean isSmartExpand() {
        return false;
    }
}

