/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jdom.Element;

public class ResourceBundleEditorProvider
extends FileTypeFactory
implements FileEditorProvider,
DumbAware {
    private static final ResourceBundleFileType RESOURCE_BUNDLE_FILE_TYPE = new ResourceBundleFileType();

    public boolean accept(final Project project, final VirtualFile file) {
        if (file instanceof ResourceBundleAsVirtualFile) {
            return true;
        }
        if (!file.isValid()) {
            return false;
        }
        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return PsiManager.getInstance((Project)project).findFile(file);
            }
        });
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
        return propertiesFile != null && propertiesFile.getResourceBundle().getPropertiesFiles().size() > 1;
    }

    public FileEditor createEditor(Project project, VirtualFile file) {
        ResourceBundle resourceBundle;
        if (file instanceof ResourceBundleAsVirtualFile) {
            resourceBundle = ((ResourceBundleAsVirtualFile)file).getResourceBundle();
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                throw new IllegalArgumentException("psifile cannot be null");
            }
            resourceBundle = PropertiesImplUtil.getPropertiesFile(psiFile).getResourceBundle();
        }
        return new ResourceBundleEditor(resourceBundle);
    }

    public void disposeEditor(FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    public FileEditorState readState(Element element, Project project, VirtualFile file) {
        return new ResourceBundleEditor.ResourceBundleEditorState(null);
    }

    public void writeState(FileEditorState state, Project project, Element element) {
    }

    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }

    public String getEditorTypeId() {
        return "ResourceBundle";
    }

    public void createFileTypes(FileTypeConsumer consumer) {
        consumer.consume((FileType)RESOURCE_BUNDLE_FILE_TYPE, "");
    }
}

