/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;

public class PropertiesGroupingStructureViewComponent
extends StructureViewComponent {
    protected PropertiesGroupingStructureViewComponent(Project project, FileEditor editor, PropertiesGroupingStructureViewModel structureViewModel) {
        super(editor, (StructureViewModel)structureViewModel, project, true);
        this.showToolbar();
    }

    protected void addGroupByActions(DefaultActionGroup result) {
        super.addGroupByActions(result);
        result.add((AnAction)new ChangeGroupSeparatorAction());
    }

    public String getHelpID() {
        return "editing.propertyFile.bundleEditor";
    }

    private class ChangeGroupSeparatorAction
    extends DefaultActionGroup {
        private final Set<String> myPredefinedSeparators;

        public ChangeGroupSeparatorAction() {
            super("Group by: ", true);
            this.myPredefinedSeparators = new LinkedHashSet<String>();
            this.myPredefinedSeparators.add(".");
            this.myPredefinedSeparators.add("_");
            this.myPredefinedSeparators.add("/");
            String currentSeparator = this.getCurrentSeparator();
            if (!this.myPredefinedSeparators.contains(currentSeparator)) {
                this.myPredefinedSeparators.add(currentSeparator);
            }
            this.refillActionGroup();
        }

        public final void update(AnActionEvent e) {
            String separator = this.getCurrentSeparator();
            Presentation presentation = e.getPresentation();
            presentation.setText("Group by: " + separator, false);
        }

        private String getCurrentSeparator() {
            return ((PropertiesGroupingStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).getSeparator();
        }

        private void refillActionGroup() {
            this.removeAll();
            for (final String separator : this.myPredefinedSeparators) {
                if (separator.equals(this.getCurrentSeparator())) continue;
                AnAction action = new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        ((PropertiesGroupingStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).setSeparator(separator);
                        PropertiesGroupingStructureViewComponent.this.setActionActive("GROUP_BY_PREFIXES", true);
                        ChangeGroupSeparatorAction.this.refillActionGroup();
                        PropertiesGroupingStructureViewComponent.this.rebuild();
                    }
                };
                action.getTemplatePresentation().setText(separator, false);
                this.add(action);
            }
            this.add(new SelectSeparatorAction());
        }

        private final class SelectSeparatorAction
        extends AnAction {
            public SelectSeparatorAction() {
                super(PropertiesBundle.message("select.separator.action.with.empty.separator.name", new Object[0]));
            }

            public final void actionPerformed(AnActionEvent e) {
                String[] strings = ArrayUtil.toStringArray((Collection)ChangeGroupSeparatorAction.this.myPredefinedSeparators);
                String current = ChangeGroupSeparatorAction.this.getCurrentSeparator();
                String separator = Messages.showEditableChooseDialog((String)PropertiesBundle.message("select.property.separator.dialog.text", new Object[0]), (String)PropertiesBundle.message("select.property.separator.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])strings, (String)current, null);
                if (separator == null) {
                    return;
                }
                ChangeGroupSeparatorAction.this.myPredefinedSeparators.add(separator);
                ChangeGroupSeparatorAction.this.refillActionGroup();
            }
        }
    }
}

