/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.customizeActions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class CombinePropertiesFilesAction
extends AnAction {
    public CombinePropertiesFilesAction() {
        super(PropertiesBundle.message("combine.properties.files.title", new Object[0]), null, AllIcons.FileTypes.Properties);
    }

    public void actionPerformed(AnActionEvent e) {
        List<PropertiesFile> propertiesFiles = CombinePropertiesFilesAction.getPropertiesFiles(e);
        String newBaseName = Messages.showInputDialog((Project)propertiesFiles.get(0).getProject(), (String)PropertiesBundle.message("combine.properties.files.prompt.text", new Object[0]), (String)PropertiesBundle.message("combine.properties.files.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)PropertiesUtil.getDefaultBaseName(propertiesFiles), (InputValidator)new MyInputValidator(propertiesFiles));
        if (newBaseName != null) {
            Project project = propertiesFiles.get(0).getProject();
            ResourceBundleManager.getInstance(project).combineToResourceBundle(propertiesFiles, newBaseName);
            ResourceBundle resourceBundle = propertiesFiles.get(0).getResourceBundle();
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new ResourceBundleAsVirtualFile(resourceBundle), true);
            ProjectView.getInstance((Project)project).refresh();
        }
    }

    public void update(AnActionEvent e) {
        boolean isAvailable;
        List<PropertiesFile> propertiesFiles = CombinePropertiesFilesAction.getPropertiesFiles(e);
        boolean bl = isAvailable = propertiesFiles != null && propertiesFiles.size() > 1;
        if (isAvailable) {
            for (PropertiesFile propertiesFile : propertiesFiles) {
                if (propertiesFile.getResourceBundle().getPropertiesFiles().size() == 1) continue;
                isAvailable = false;
                break;
            }
        }
        e.getPresentation().setVisible(isAvailable);
    }

    private static List<PropertiesFile> getPropertiesFiles(AnActionEvent e) {
        PsiElement[] psiElements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
        if (psiElements == null || psiElements.length == 0) {
            return null;
        }
        ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>(psiElements.length);
        for (PsiElement psiElement : psiElements) {
            if (!(psiElement instanceof PsiFile)) {
                return null;
            }
            PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)psiElement);
            if (propertiesFile == null) {
                return null;
            }
            files.add(propertiesFile);
        }
        return files;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static class MyInputValidator
    implements InputValidatorEx {
        private final List<PropertiesFile> myPropertiesFiles;

        private MyInputValidator(List<PropertiesFile> propertiesFiles) {
            this.myPropertiesFiles = propertiesFiles;
        }

        public boolean checkInput(String newBaseName) {
            return !newBaseName.isEmpty() && this.checkBaseName(newBaseName) == null;
        }

        public boolean canClose(String newBaseName) {
            return true;
        }

        public String getErrorText(String inputString) {
            return this.checkInput(inputString) ? null : String.format("Base name must be valid for file '%s'", this.checkBaseName(inputString).getFailedFile());
        }

        private BaseNameError checkBaseName(String baseNameCandidate) {
            for (PropertiesFile propertiesFile : this.myPropertiesFiles) {
                String name = propertiesFile.getVirtualFile().getName();
                if (name.startsWith(baseNameCandidate) && PropertiesUtil.BASE_NAME_BORDER_CHAR.contains(Character.valueOf(name.charAt(baseNameCandidate.length())))) continue;
                return new BaseNameError(name);
            }
            return null;
        }

        private static class BaseNameError {
            private final String myFailedFile;

            private BaseNameError(String failedFile) {
                this.myFailedFile = failedFile;
            }

            public String getFailedFile() {
                return this.myFailedFile;
            }
        }
    }
}

