/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;

public class ResourceBundleImpl
extends ResourceBundle {
    private final PropertiesFile myDefaultPropertiesFile;

    public ResourceBundleImpl(PropertiesFile defaultPropertiesFile) {
        this.myDefaultPropertiesFile = defaultPropertiesFile;
    }

    @Override
    public List<PropertiesFile> getPropertiesFiles() {
        if (ResourceBundleManager.getInstance(this.getProject()).isDefaultDissociated(this.myDefaultPropertiesFile.getVirtualFile())) {
            return Collections.singletonList(this.myDefaultPropertiesFile);
        }
        PsiFile[] children = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

            public PsiFile[] compute() {
                return ResourceBundleImpl.this.myDefaultPropertiesFile.getParent().getFiles();
            }
        });
        String baseName = this.getBaseName();
        SmartList result = new SmartList();
        String defaultNameWithoutExtension = FileUtil.getNameWithoutExtension((String)this.myDefaultPropertiesFile.getName());
        for (PsiFile file : children) {
            PropertiesFile propertiesFile;
            if (!file.isValid() || file.getVirtualFile().getExtension() == null || !Comparing.strEqual((String)PropertiesUtil.getDefaultBaseName(file.getVirtualFile()), (String)baseName) || (propertiesFile = PropertiesImplUtil.getPropertiesFile(file)) == null) continue;
            result.add(propertiesFile);
            if (propertiesFile == this.myDefaultPropertiesFile || FileUtil.getNameWithoutExtension((String)propertiesFile.getName()).compareTo(defaultNameWithoutExtension) != 0) continue;
            return Collections.singletonList(this.myDefaultPropertiesFile);
        }
        return result;
    }

    @Override
    public PropertiesFile getDefaultPropertiesFile() {
        return this.myDefaultPropertiesFile;
    }

    @Override
    public String getBaseName() {
        return ResourceBundleManager.getInstance(this.getProject()).getBaseName(this.myDefaultPropertiesFile.getContainingFile());
    }

    @Override
    public VirtualFile getBaseDirectory() {
        return this.myDefaultPropertiesFile.getParent().getVirtualFile();
    }

    @Override
    public Project getProject() {
        return this.myDefaultPropertiesFile.getProject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleImpl resourceBundle = (ResourceBundleImpl)o;
        return this.myDefaultPropertiesFile.equals(resourceBundle.myDefaultPropertiesFile);
    }

    public int hashCode() {
        return this.myDefaultPropertiesFile.hashCode();
    }

    public String getUrl() {
        return this.getBaseDirectory() + "/" + this.getBaseName();
    }

    public String toString() {
        return "ResourceBundleImpl:" + this.getBaseName();
    }
}

