/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.GuiUtils;
import java.awt.Color;
import java.util.Collection;

public class PropertiesDocumentationProvider
extends AbstractDocumentationProvider {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof IProperty) {
            return "\"" + PropertiesDocumentationProvider.renderPropertyValue((IProperty)element) + "\"" + PropertiesDocumentationProvider.getLocationString(element);
        }
        return null;
    }

    private static String getLocationString(PsiElement element) {
        PsiFile file = element.getContainingFile();
        return file != null ? " [" + file.getName() + "]" : "";
    }

    private static String renderPropertyValue(IProperty prop) {
        String raw = prop.getValue();
        if (raw == null) {
            return "<i>empty</i>";
        }
        return StringUtil.escapeXml((String)raw);
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        if (element instanceof IProperty) {
            IProperty property = (IProperty)element;
            String text = property.getDocCommentText();
            String info = "";
            if (text != null) {
                TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_COMMENT).clone();
                Color background = attributes.getBackgroundColor();
                if (background != null) {
                    info = info + "<div bgcolor=#" + GuiUtils.colorToHex((Color)background) + ">";
                }
                String doc = StringUtil.join((Collection)StringUtil.split((String)text, (String)"\n"), (String)"<br>");
                info = info + "<font color=#" + GuiUtils.colorToHex((Color)attributes.getForegroundColor()) + ">" + doc + "</font>\n<br>";
                if (background != null) {
                    info = info + "</div>";
                }
            }
            info = info + "\n<b>" + property.getName() + "</b>=\"" + PropertiesDocumentationProvider.renderPropertyValue((IProperty)element) + "\"";
            info = info + PropertiesDocumentationProvider.getLocationString(element);
            return info;
        }
        return null;
    }
}

