/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertySuppressableInspectionBase;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;

public class WrongPropertyKeyValueDelimiterInspection
extends PropertySuppressableInspectionBase {
    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        if (!(holder.getFile() instanceof PropertiesFileImpl)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        PropertiesCodeStyleSettings codeStyleSettings = PropertiesCodeStyleSettings.getInstance(holder.getProject());
        final char codeStyleKeyValueDelimiter = codeStyleSettings.KEY_VALUE_DELIMITER;
        return new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                Character delimiter;
                if (element instanceof PropertyImpl && (delimiter = ((PropertyImpl)element).getKeyValueDelimiter()) != null && !delimiter.equals(Character.valueOf(codeStyleKeyValueDelimiter))) {
                    holder.registerProblem(element, PropertiesBundle.message("wrong.property.key.value.delimiter.inspection.display.name", new Object[0]), new LocalQuickFix[]{new ReplaceKeyValueDelimiterQuickFix(element)});
                }
            }
        };
    }

    private static final class ReplaceKeyValueDelimiterQuickFix
    extends LocalQuickFixOnPsiElement
    implements HighPriorityAction {
        public ReplaceKeyValueDelimiterQuickFix(PsiElement element) {
            super(element);
        }

        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(Project project, PsiFile file, PsiElement element, PsiElement endElement) {
            ((PropertyImpl)element).replaceKeyValueDelimiterWithDefault();
        }

        public String getFamilyName() {
            return "Replace Property Key/Value Delimiter According Code Style";
        }
    }
}

