/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.MutableAccessor;
import java.util.List;

public class XmlSerializerUtil {
    private XmlSerializerUtil() {
    }

    public static <T> void copyBean(T from, T to) {
        assert (from.getClass().isAssignableFrom(to.getClass())) : "Beans of different classes specified: Cannot assign " + from.getClass() + " to " + to.getClass();
        for (MutableAccessor accessor : BeanBinding.getAccessors(from.getClass())) {
            accessor.set(to, accessor.read(from));
        }
    }

    public static <T> T createCopy(T from) {
        try {
            Object to = ReflectionUtil.newInstance(from.getClass(), new Class[0]);
            XmlSerializerUtil.copyBean(from, to);
            return (T)to;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static List<MutableAccessor> getAccessors(Class<?> aClass) {
        return BeanBinding.getAccessors(aClass);
    }
}

