/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializationException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class PropertyAccessor
implements MutableAccessor {
    private final String myName;
    private final Class<?> myType;
    private final Method myReadMethod;
    private final Method setter;
    private final Type myGenericType;

    public PropertyAccessor(PropertyDescriptor descriptor) {
        this(descriptor.getName(), descriptor.getPropertyType(), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    public PropertyAccessor(String name, Class<?> type, Method readMethod, Method writeMethod) {
        this.myName = name;
        this.myType = type;
        this.myReadMethod = readMethod;
        this.setter = writeMethod;
        this.myGenericType = this.myReadMethod.getGenericReturnType();
        try {
            this.myReadMethod.setAccessible(true);
            this.setter.setAccessible(true);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
    }

    @Override
    public Object read(Object o) {
        try {
            return this.myReadMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void set(Object host, Object value) {
        try {
            this.setter.invoke(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void setBoolean(Object host, boolean value) {
        this.set(host, value);
    }

    @Override
    public void setInt(Object host, int value) {
        this.set(host, value);
    }

    @Override
    public void setShort(Object host, short value) {
        this.set(host, value);
    }

    @Override
    public void setLong(Object host, long value) {
        this.set(host, value);
    }

    @Override
    public void setDouble(Object host, double value) {
        this.set(host, value);
    }

    @Override
    public void setFloat(Object host, float value) {
        this.set(host, Float.valueOf(value));
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = this.myReadMethod.getAnnotation(annotationClass);
        return annotation == null ? this.setter.getAnnotation(annotationClass) : annotation;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Class<?> getValueClass() {
        return this.myType;
    }

    @Override
    public Type getGenericType() {
        return this.myGenericType;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    public String toString() {
        return "PropertyAccessor[" + this.myReadMethod.getDeclaringClass().getName() + "." + this.getName() + "]";
    }

    @Override
    public void write(Object o, Object value) {
        this.set(o, value);
    }
}

