/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import java.util.List;
import org.jdom.Element;

class CompactCollectionBinding
extends Binding {
    private final String name;

    protected CompactCollectionBinding(MutableAccessor accessor) {
        super(accessor);
        this.name = this.myAccessor.getName();
    }

    @Override
    public Object serialize(Object o, Object context, SerializationFilter filter) {
        Element result = new Element(this.name);
        List list = (List)o;
        if (list.isEmpty()) {
            return result;
        }
        for (String item : list) {
            result.addContent(new Element("item").setAttribute("value", item));
        }
        return result;
    }

    @Override
    public Object deserialize(Object context, Element element) {
        List list;
        block4: {
            block3: {
                list = (List)context;
                list.clear();
                if (!element.getName().equals(this.name)) break block3;
                for (Element item : element.getChildren("item")) {
                    ContainerUtil.addIfNotNull(list, item.getAttributeValue("value"));
                }
                break block4;
            }
            Element value = element.getChild("value");
            if (value != null) {
                value = value.getChild("list");
            }
            if (value == null) break block4;
            for (Element item : value.getChildren("item")) {
                ContainerUtil.addIfNotNull(list, item.getAttributeValue("itemvalue"));
            }
        }
        return list;
    }

    @Override
    public boolean isBoundTo(Element element) {
        String elementName = element.getName();
        if (this.isNameEqual(elementName)) {
            return true;
        }
        if (elementName.equals("option")) {
            return this.isNameEqual(element.getAttributeValue("name"));
        }
        return false;
    }

    private boolean isNameEqual(String value) {
        if (value == null) {
            return false;
        }
        if (value.equals(this.name)) {
            return true;
        }
        if (value.length() == this.name.length() + 2 && value.startsWith("my")) {
            return Character.isUpperCase(value.charAt(2)) && value.regionMatches(true, 2, this.name, 0, this.name.length());
        }
        return false;
    }
}

