/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;

public class UniqueNameGenerator
implements Condition<String> {
    private final Set<String> myExistingNames = new HashSet<String>();

    public <T> UniqueNameGenerator(Collection<T> elements, Function<T, String> namer) {
        for (T t : elements) {
            this.addExistingName(namer != null ? namer.fun(t) : t.toString());
        }
    }

    public UniqueNameGenerator() {
    }

    @Override
    public final boolean value(String candidate) {
        return !this.myExistingNames.contains(candidate);
    }

    public final boolean isUnique(String name, String prefix, String suffix) {
        return this.value(prefix + name + suffix);
    }

    public static String generateUniqueName(String defaultName, Collection<String> existingNames) {
        return UniqueNameGenerator.generateUniqueName(defaultName, "", "", existingNames);
    }

    public static String generateUniqueName(String defaultName, String prefix, String suffix, final Collection<String> existingNames) {
        return UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, new Condition<String>(){

            @Override
            public boolean value(String s) {
                return !existingNames.contains(s);
            }
        });
    }

    public static String generateUniqueName(String defaultName, Condition<String> validator) {
        return UniqueNameGenerator.generateUniqueName(defaultName, "", "", validator);
    }

    public static String generateUniqueName(String defaultName, String prefix, String suffix, Condition<String> validator) {
        return UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, "", "", validator);
    }

    public static String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber, Condition<String> validator) {
        String defaultFullName = prefix + defaultName + suffix;
        if (validator.value(defaultFullName)) {
            return defaultFullName;
        }
        int i = 2;
        String fullName;
        while (!validator.value(fullName = prefix + defaultName + beforeNumber + i + afterNumber + suffix)) {
            ++i;
        }
        return fullName;
    }

    public String generateUniqueName(String defaultName, String prefix, String suffix) {
        return this.generateUniqueName(defaultName, prefix, suffix, "", "");
    }

    public String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber) {
        String result = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, beforeNumber, afterNumber, this);
        this.addExistingName(result);
        return result;
    }

    public void addExistingName(String result) {
        this.myExistingNames.add(result);
    }

    public String generateUniqueName(String defaultName) {
        return this.generateUniqueName(defaultName, "", "");
    }
}

