/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import java.util.regex.Pattern;

public class SemVer
implements Comparable<SemVer> {
    private final int myMajor;
    private final int myMinor;
    private final int myPatch;
    private final String myRawVersion;

    public SemVer(String rawVersion, int major, int minor, int patch) {
        this.myRawVersion = rawVersion;
        this.myMajor = major;
        this.myMinor = minor;
        this.myPatch = patch;
    }

    public String getRawVersion() {
        return this.myRawVersion;
    }

    public int getMajor() {
        return this.myMajor;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public int getPatch() {
        return this.myPatch;
    }

    public String getParsedVersion() {
        return this.myMajor + "." + this.myMinor + "." + this.myPatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        if (this.myMajor != semVer.myMajor) {
            return false;
        }
        if (this.myMinor != semVer.myMinor) {
            return false;
        }
        return this.myPatch == semVer.myPatch;
    }

    public int hashCode() {
        int result = this.myMajor;
        result = 31 * result + this.myMinor;
        result = 31 * result + this.myPatch;
        return result;
    }

    public String toString() {
        return this.myRawVersion;
    }

    public static SemVer parseFromText(String text) {
        String[] comps = text.split(Pattern.quote("."), 3);
        if (comps.length != 3) {
            return null;
        }
        Integer major = SemVer.toInteger(comps[0]);
        Integer minor = SemVer.toInteger(comps[1]);
        String patchStr = comps[2];
        int dashInd = patchStr.indexOf(45);
        if (dashInd >= 0) {
            patchStr = patchStr.substring(0, dashInd);
        }
        Integer patch = SemVer.toInteger(patchStr);
        if (major != null && minor != null && patch != null) {
            return new SemVer(text, major, minor, patch);
        }
        return null;
    }

    private static Integer toInteger(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public int compareTo(SemVer other) {
        if (this.getMajor() != other.getMajor()) {
            return this.getMajor() - other.getMajor();
        }
        if (this.getMinor() != other.getMinor()) {
            return this.getMinor() - other.getMinor();
        }
        if (this.getPatch() != other.getPatch()) {
            return this.getPatch() - other.getPatch();
        }
        return 0;
    }
}

