/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages;

public class Topic<L> {
    private final String myDisplayName;
    private final Class<L> myListenerClass;
    private final BroadcastDirection myBroadcastDirection;

    public Topic(String displayName, Class<L> listenerClass) {
        this(displayName, listenerClass, BroadcastDirection.TO_CHILDREN);
    }

    public Topic(String displayName, Class<L> listenerClass, BroadcastDirection broadcastDirection) {
        this.myDisplayName = displayName;
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public Class<L> getListenerClass() {
        return this.myListenerClass;
    }

    public String toString() {
        return this.myDisplayName;
    }

    public static <L> Topic<L> create(String displayName, Class<L> listenerClass) {
        return new Topic<L>(displayName, listenerClass);
    }

    public static <L> Topic<L> create(String displayName, Class<L> listenerClass, BroadcastDirection direction) {
        return new Topic<L>(displayName, listenerClass, direction);
    }

    public BroadcastDirection getBroadcastDirection() {
        return this.myBroadcastDirection;
    }

    public static enum BroadcastDirection {
        TO_CHILDREN,
        NONE,
        TO_PARENT;

    }
}

