/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.containers.ContainerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;

public class CompoundRuntimeException
extends RuntimeException {
    private final List<Throwable> myThrowables;

    public CompoundRuntimeException(List<Throwable> throwables) {
        super("Several Exceptions occurred", throwables.get(0));
        this.myThrowables = throwables;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        for (Throwable throwable : this.myThrowables) {
            throwable.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        for (Throwable throwable : this.myThrowables) {
            throwable.printStackTrace(s);
        }
    }

    public static void doThrow(List<Throwable> throwables) {
        if (ContainerUtil.isEmpty(throwables)) {
            return;
        }
        if (throwables.size() == 1) {
            Throwable throwable = throwables.get(0);
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        throw new CompoundRuntimeException(throwables);
    }
}

