/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.MapBackedFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import com.intellij.util.keyFMap.PairElementsFMap;

public class ArrayBackedFMap
implements KeyFMap {
    static final int ARRAY_THRESHOLD = 8;
    private final int[] keys;
    private final Object[] values;

    ArrayBackedFMap(int[] keys, Object[] values) {
        this.keys = keys;
        this.values = values;
    }

    @Override
    public <V> KeyFMap plus(Key<V> key, V value) {
        int i;
        int oldSize = this.size();
        int keyCode = key.hashCode();
        int[] newKeys = null;
        Object[] newValues = null;
        for (i = 0; i < oldSize; ++i) {
            int oldKey = this.keys[i];
            if (keyCode != oldKey) continue;
            if (value == this.values[i]) {
                return this;
            }
            newKeys = new int[oldSize];
            newValues = new Object[oldSize];
            System.arraycopy(this.keys, 0, newKeys, 0, oldSize);
            System.arraycopy(this.values, 0, newValues, 0, oldSize);
            newValues[i] = value;
            break;
        }
        if (i == oldSize) {
            if (oldSize == 8) {
                return new MapBackedFMap(this.keys, keyCode, this.values, value);
            }
            int newSize = oldSize + 1;
            newKeys = new int[newSize];
            newValues = new Object[newSize];
            System.arraycopy(this.keys, 0, newKeys, 0, oldSize);
            System.arraycopy(this.values, 0, newValues, 0, oldSize);
            newKeys[oldSize] = keyCode;
            newValues[oldSize] = value;
        }
        return new ArrayBackedFMap(newKeys, newValues);
    }

    private int size() {
        return this.keys.length;
    }

    @Override
    public KeyFMap minus(Key<?> key) {
        int oldSize = this.size();
        int keyCode = key.hashCode();
        for (int i = 0; i < oldSize; ++i) {
            int oldKey = this.keys[i];
            if (keyCode != oldKey) continue;
            if (oldSize == 3) {
                int i1 = (2 - i) / 2;
                int i2 = 3 - (i + 2) / 2;
                Key key1 = Key.getKeyByIndex(this.keys[i1]);
                Key key2 = Key.getKeyByIndex(this.keys[i2]);
                if (key1 == null && key2 == null) {
                    return EMPTY_MAP;
                }
                if (key1 == null) {
                    return new OneElementFMap<Object>(key2, this.values[i2]);
                }
                if (key2 == null) {
                    return new OneElementFMap<Object>(key1, this.values[i1]);
                }
                return new PairElementsFMap(key1, this.values[i1], key2, this.values[i2]);
            }
            int newSize = oldSize - 1;
            int[] newKeys = new int[newSize];
            Object[] newValues = new Object[newSize];
            System.arraycopy(this.keys, 0, newKeys, 0, i);
            System.arraycopy(this.values, 0, newValues, 0, i);
            System.arraycopy(this.keys, i + 1, newKeys, i, oldSize - i - 1);
            System.arraycopy(this.values, i + 1, newValues, i, oldSize - i - 1);
            return new ArrayBackedFMap(newKeys, newValues);
        }
        return this;
    }

    @Override
    public <V> V get(Key<V> key) {
        int oldSize = this.size();
        int keyCode = key.hashCode();
        for (int i = 0; i < oldSize; ++i) {
            int oldKey = this.keys[i];
            if (keyCode != oldKey) continue;
            return (V)this.values[i];
        }
        return null;
    }

    @Override
    public String toString() {
        String s = "";
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            Object value = this.values[i];
            s = s + (s.isEmpty() ? "" : ", ") + Key.getKeyByIndex(key) + " -> " + value;
        }
        return "(" + s + ")";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public int[] getKeyIds() {
        return this.keys;
    }

    @Override
    public Key[] getKeys() {
        return ArrayBackedFMap.getKeysByIndices(this.keys);
    }

    public Object[] getValues() {
        return this.values;
    }

    static Key[] getKeysByIndices(int[] indexes) {
        Key[] result = new Key[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            result[i] = Key.getKeyByIndex(indexes[i]);
        }
        return result;
    }
}

