/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReplicatorInputStream
extends InputStream {
    private final BufferExposingByteArrayOutputStream myTarget;
    private final InputStream mySource;
    private int markedSize;

    public ReplicatorInputStream(InputStream source, BufferExposingByteArrayOutputStream target) {
        this.mySource = source;
        this.myTarget = target;
    }

    @Override
    public int read() throws IOException {
        int b = this.mySource.read();
        if (b == -1) {
            return -1;
        }
        this.myTarget.write(b);
        return b;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mySource.mark(readlimit);
        this.markedSize = this.myTarget.size();
    }

    @Override
    public boolean markSupported() {
        return this.mySource.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.mySource.reset();
        this.myTarget.backOff(this.myTarget.size() - this.markedSize);
        this.markedSize = 0;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.mySource.read(b, off, len);
        if (count < 0) {
            return count;
        }
        this.myTarget.write(b, off, count);
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        int skipped = this.read(new byte[(int)n]);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.mySource.available();
    }

    @Override
    public void close() throws IOException {
        this.mySource.close();
        this.myTarget.close();
    }

    public int getBytesRead() {
        return this.myTarget.size();
    }
}

