/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class BaseOutputReader
extends BaseDataReader {
    protected static final int DELAY_AFTER_BLOCKING_READ = 10;
    protected final Reader myReader;
    private final char[] myBuffer = new char[8192];
    private final StringBuilder myTextBuffer = new StringBuilder();
    private ExecutorService myExecutorService;
    private boolean skipLF = false;
    private volatile Future myScheduledSubmitter;
    private Runnable myTokenSubmitter;

    public BaseOutputReader(InputStream inputStream, Charset charset) {
        this(inputStream, charset, null);
    }

    public BaseOutputReader(InputStream inputStream, Charset charset, BaseDataReader.SleepingPolicy sleepingPolicy) {
        this(BaseOutputReader.createInputStreamReader(inputStream, charset), sleepingPolicy);
    }

    public BaseOutputReader(Reader reader) {
        this(reader, null);
    }

    public BaseOutputReader(Reader reader, BaseDataReader.SleepingPolicy sleepingPolicy) {
        super(sleepingPolicy);
        if (sleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING) {
            if (!(reader instanceof BaseInputStreamReader)) {
                throw new IllegalArgumentException("Blocking policy can be used only with BaseInputStreamReader, that doesn't lock on close");
            }
            this.myExecutorService = Executors.newSingleThreadExecutor();
            this.myTokenSubmitter = new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(10L);
                        BaseOutputReader.this.submitToken();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
        }
        this.myReader = reader;
    }

    private static Reader createInputStreamReader(InputStream streamToRead, Charset charset) {
        if (charset == null) {
            return new BaseInputStreamReader(streamToRead);
        }
        return new BaseInputStreamReader(streamToRead, charset);
    }

    private void processLine(char[] buffer, StringBuilder token, int n) {
        for (int i = 0; i < n; ++i) {
            char c = buffer[i];
            if (this.skipLF && c != '\n') {
                token.append('\r');
            }
            if (c == '\r') {
                this.skipLF = true;
            } else {
                this.skipLF = false;
                token.append(c);
            }
            if (c != '\n') continue;
            this.onTextAvailable(token.toString());
            token.setLength(0);
        }
    }

    protected final boolean readAvailableNonBlocking() throws IOException {
        int n;
        char[] buffer = this.myBuffer;
        StringBuilder token = this.myTextBuffer;
        token.setLength(0);
        boolean read = false;
        while (this.myReader.ready() && (n = this.myReader.read(buffer)) > 0) {
            read = true;
            this.processLine(buffer, token, n);
        }
        this.submitToken();
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean readAvailableBlocking() throws IOException {
        int n;
        char[] buffer = this.myBuffer;
        StringBuilder token = this.myTextBuffer;
        token.setLength(0);
        boolean read = false;
        while ((n = this.myReader.read(buffer)) > 0) {
            if (this.myScheduledSubmitter != null) {
                this.myScheduledSubmitter.cancel(true);
            }
            read = true;
            StringBuilder stringBuilder = this.myTextBuffer;
            synchronized (stringBuilder) {
                this.processLine(buffer, token, n);
            }
            this.myScheduledSubmitter = this.myExecutorService.submit(this.myTokenSubmitter);
        }
        this.submitToken();
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitToken() {
        StringBuilder stringBuilder = this.myTextBuffer;
        synchronized (stringBuilder) {
            if (this.myTextBuffer.length() != 0) {
                this.onTextAvailable(this.myTextBuffer.toString());
                this.myTextBuffer.setLength(0);
            }
        }
    }

    protected Future getScheduledSubmitter() {
        return this.myScheduledSubmitter;
    }

    @Override
    protected boolean readAvailable() throws IOException {
        return this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING ? this.readAvailableBlocking() : this.readAvailableNonBlocking();
    }

    @Override
    protected void close() throws IOException {
        this.myReader.close();
    }

    protected abstract void onTextAvailable(String var1);
}

