/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

public class AntivirusDetector {
    private static final int THRESHOULD = 500;
    private boolean myEnabled = false;
    private Runnable myCallback;
    private static final AntivirusDetector ourInstance = new AntivirusDetector();

    public static AntivirusDetector getInstance() {
        return ourInstance;
    }

    private AntivirusDetector() {
    }

    public void enable(Runnable callback) {
        this.myCallback = callback;
        this.myEnabled = true;
    }

    public void disable() {
        this.myEnabled = false;
    }

    public void execute(Runnable r) {
        if (!this.myEnabled) {
            r.run();
            return;
        }
        long now = System.currentTimeMillis();
        r.run();
        long delta = System.currentTimeMillis() - now;
        if (delta > 500L) {
            this.disable();
            this.myCallback.run();
        }
    }
}

