/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.RefHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class WeakHashMap<K, V>
extends RefHashMap<K, V> {
    public WeakHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public WeakHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public WeakHashMap() {
    }

    public WeakHashMap(Map<K, V> t) {
        super(t);
    }

    @Override
    protected <T> RefHashMap.Key<T> createKey(T k, ReferenceQueue<? super T> q) {
        return new WeakKey(k, q);
    }

    private static class WeakKey<T>
    extends WeakReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;

        private WeakKey(T k, ReferenceQueue<? super T> q) {
            super(k, q);
            this.myHash = k.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            return this.myHash == o.hashCode() && Comparing.equal(t, u);
        }

        public int hashCode() {
            return this.myHash;
        }

        public String toString() {
            Object t = this.get();
            return "WeakKey(" + t + ", " + this.myHash + ")";
        }
    }
}

