/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentMap;

public abstract class WeakFactoryMap<T, V> {
    private final ConcurrentMap<T, WeakReference<V>> myMap = ContainerUtil.createConcurrentWeakMap();

    protected abstract V create(T var1);

    public final V get(T key) {
        WeakReference reference = (WeakReference)this.myMap.get(key);
        Object v = SoftReference.dereference(reference);
        if (v != null) {
            return v == ObjectUtils.NULL ? null : (V)v;
        }
        V value = this.create(key);
        WeakReference<Object> valueRef = new WeakReference<Object>(value == null ? ObjectUtils.NULL : value);
        WeakReference<Object> prevRef = this.myMap.putIfAbsent(key, valueRef);
        Object prev = SoftReference.dereference(prevRef);
        return (V)(prev == null || prev == ObjectUtils.NULL ? value : prev);
    }

    public final boolean containsKey(T key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    private static <K> K getKey(K key) {
        return (K)(key == null ? ObjectUtils.NULL : key);
    }

    public void put(T key, V value) {
        this.myMap.put(WeakFactoryMap.getKey(key), new WeakReference<Object>(value == null ? ObjectUtils.NULL : value));
    }
}

