/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.RefHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.Map;

public final class SoftHashMap<K, V>
extends RefHashMap<K, V> {
    public SoftHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SoftHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public SoftHashMap() {
    }

    public SoftHashMap(Map<K, V> t) {
        super(t);
    }

    public SoftHashMap(TObjectHashingStrategy<K> hashingStrategy) {
        super(hashingStrategy);
    }

    @Override
    protected <T> RefHashMap.Key<T> createKey(T k, ReferenceQueue<? super T> q) {
        return new SoftKey(k, q);
    }

    private static class SoftKey<T>
    extends SoftReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;

        private SoftKey(T k, ReferenceQueue<? super T> q) {
            super(k, q);
            this.myHash = k.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            if (this.myHash != o.hashCode()) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }

        public String toString() {
            return "SoftHashMap.SoftKey(" + this.get() + ")";
        }
    }
}

