/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.SLRUCache;
import java.util.concurrent.locks.Lock;
import jsr166e.extra.SequenceLock;

public class RecentStringInterner {
    private final int myStripeMask;
    private final SLRUCache<String, String>[] myInterns;
    private final Lock[] myStripeLocks;
    private final LowMemoryWatcher myLowMemoryWatcher;

    public RecentStringInterner() {
        this(8192);
    }

    public RecentStringInterner(int capacity) {
        int stripes = 16;
        this.myInterns = new SLRUCache[16];
        this.myStripeLocks = new Lock[this.myInterns.length];
        for (int i = 0; i < this.myInterns.length; ++i) {
            this.myInterns[i] = new SLRUCache<String, String>(capacity / 16, capacity / 16){

                @Override
                public String createValue(String key) {
                    return key;
                }

                @Override
                protected void putToProtectedQueue(String key, String value) {
                    super.putToProtectedQueue(value, value);
                }
            };
            this.myStripeLocks[i] = new SequenceLock();
        }
        assert (Integer.highestOneBit(16) == 16);
        this.myStripeMask = 15;
        this.myLowMemoryWatcher = LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                RecentStringInterner.this.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String s) {
        if (s == null) {
            return null;
        }
        int stripe = Math.abs(s.hashCode()) & this.myStripeMask;
        try {
            this.myStripeLocks[stripe].lock();
            String string = this.myInterns[stripe].get(s);
            return string;
        }
        finally {
            this.myStripeLocks[stripe].unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < this.myInterns.length; ++i) {
            try {
                this.myStripeLocks[i].lock();
                this.myInterns[i].clear();
                continue;
            }
            finally {
                this.myStripeLocks[i].unlock();
            }
        }
    }
}

