/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.LinkedHashMap;
import com.intellij.util.containers.LinkedHashSet;
import com.intellij.util.containers.Stack;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class ContainerUtilRt {
    private static final int ARRAY_COPY_THRESHOLD = 20;

    public static <K, V> java.util.HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> java.util.HashMap<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap(map);
    }

    public static <K, V> Map<K, V> newHashMap(List<K> keys, List<V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException(keys + " should have same length as " + values);
        }
        java.util.HashMap<K, V> map = ContainerUtilRt.newHashMap();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    public static <K, V> Map<K, V> newHashMap(Pair<K, V> first, Pair<K, V>[] entries) {
        java.util.HashMap<K, V> map = ContainerUtilRt.newHashMap();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> entry : entries) {
            map.put(entry.getFirst(), entry.getSecond());
        }
        return map;
    }

    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap(Map<K, V> map) {
        return new TreeMap<K, V>(map);
    }

    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        return new LinkedHashMap(capacity);
    }

    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap(Map<K, V> map) {
        return new LinkedHashMap(map);
    }

    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap(Pair<K, V> first, Pair<K, V>[] entries) {
        java.util.LinkedHashMap<K, V> map = ContainerUtilRt.newLinkedHashMap();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> entry : entries) {
            map.put(entry.getFirst(), entry.getSecond());
        }
        return map;
    }

    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        LinkedList<T> list = ContainerUtilRt.newLinkedList();
        Collections.addAll(list, elements);
        return list;
    }

    public static <T> LinkedList<T> newLinkedList(Iterable<? extends T> elements) {
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedList(), elements);
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(T ... elements) {
        ArrayList<T> list = ContainerUtilRt.newArrayListWithCapacity(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    public static <T> ArrayList<T> newArrayList(Iterable<? extends T> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new ArrayList(collection);
        }
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newArrayList(), elements);
    }

    public static <T> ArrayList<T> newArrayListWithExpectedSize(int size) {
        return ContainerUtilRt.newArrayListWithCapacity(size);
    }

    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        return new ArrayList(size);
    }

    private static <T, C extends Collection<T>> C copy(C collection, Iterable<? extends T> elements) {
        for (T element : elements) {
            collection.add(element);
        }
        return collection;
    }

    public static <T> java.util.HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> java.util.HashSet<T> newHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <T> java.util.HashSet<T> newHashSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    public static <T> java.util.HashSet<T> newHashSet(Iterable<? extends T> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new HashSet(collection);
        }
        return ContainerUtilRt.newHashSet(elements.iterator());
    }

    public static <T> java.util.HashSet<T> newHashSet(Iterator<? extends T> iterator) {
        java.util.HashSet<T> set = ContainerUtilRt.newHashSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <T> java.util.LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <T> java.util.LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        return ContainerUtilRt.newLinkedHashSet(Arrays.asList(elements));
    }

    public static <T> java.util.LinkedHashSet<T> newLinkedHashSet(Iterable<? extends T> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new LinkedHashSet(collection);
        }
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedHashSet(), elements);
    }

    public static <T> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        TreeSet<T> set = ContainerUtilRt.newTreeSet();
        Collections.addAll(set, elements);
        return set;
    }

    public static <T> TreeSet<T> newTreeSet(Iterable<? extends T> elements) {
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newTreeSet(), elements);
    }

    public static <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    public static <T> Stack<T> newStack() {
        return new Stack();
    }

    public static <T> Stack<T> newStack(Collection<T> elements) {
        return new Stack<T>(elements);
    }

    public static <T> Stack<T> newStack(T ... initial) {
        return new Stack<T>(Arrays.asList(initial));
    }

    public static <T> List<T> emptyList() {
        return EmptyList.INSTANCE;
    }

    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        return new CopyOnWriteArrayList<T>(ContainerUtilRt.<T>emptyList());
    }

    public static <T> void addIfNotNull(T element, Collection<T> result) {
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void addIfNotNull(Collection<T> result, T element) {
        if (element != null) {
            result.add(element);
        }
    }

    public static <T, V> List<V> map2List(T[] array, Function<T, V> mapper) {
        return ContainerUtilRt.map2List(Arrays.asList(array), mapper);
    }

    public static <T, V> List<V> map2List(Collection<? extends T> collection, Function<T, V> mapper) {
        if (collection.isEmpty()) {
            return ContainerUtilRt.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        return list;
    }

    public static <T, V> Set<V> map2Set(T[] collection, Function<T, V> mapper) {
        return ContainerUtilRt.map2Set(Arrays.asList(collection), mapper);
    }

    public static <T, V> Set<V> map2Set(Collection<? extends T> collection, Function<T, V> mapper) {
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        java.util.HashSet<V> set = new java.util.HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        return set;
    }

    public static <T> T[] toArray(List<T> collection, T[] array) {
        int length = array.length;
        if (length < 20 && array.length >= collection.size()) {
            for (int i = 0; i < collection.size(); ++i) {
                array[i] = collection.get(i);
            }
            return array;
        }
        return collection.toArray(array);
    }

    public static <T> T[] toArray(Collection<T> c, T[] sample) {
        int size = c.size();
        if (size == sample.length && size < 20) {
            int i = 0;
            for (T t : c) {
                sample[i++] = t;
            }
            return sample;
        }
        return c.toArray(sample);
    }

    private static class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public Object[] toArray() {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length != 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public Iterator<T> iterator() {
            return EmptyIterator.getInstance();
        }
    }
}

