/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.Convertor;
import java.util.Comparator;

public class ComparatorUtil {
    private ComparatorUtil() {
    }

    public static <Type, Aspect> Comparator<Type> compareBy(final Convertor<Type, Aspect> aspect, final Comparator<Aspect> comparator) {
        return new Comparator<Type>(){

            @Override
            public int compare(Type element1, Type element2) {
                return comparator.compare(aspect.convert(element1), aspect.convert(element2));
            }
        };
    }

    public static <T extends Comparable<T>> T max(T o1, T o2) {
        return o1.compareTo(o2) >= 0 ? o1 : o2;
    }

    public static <T extends Comparable<T>> T min(T o1, T o2) {
        return o1.compareTo(o2) >= 0 ? o2 : o1;
    }

    public static <T> boolean equalsNullable(T a, T b) {
        if (a == null) {
            return b == null;
        }
        return b != null && a.equals(b);
    }
}

