/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.Convertor;

public class ObjectUtils {
    public static final Object NULL = new Object();

    private ObjectUtils() {
    }

    public static <T> T assertNotNull(T t) {
        return ObjectUtils._assertNotNull(t);
    }

    private static <T> T _assertNotNull(T t) {
        return t;
    }

    public static <T> T chooseNotNull(T t1, T t2) {
        return t1 == null ? t2 : t1;
    }

    public static <T> T notNull(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static <T> T tryCast(Object obj, Class<T> clazz) {
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        return null;
    }

    public static <T, S> S doIfCast(Object obj, Class<T> clazz, Convertor<T, S> convertor) {
        if (clazz.isInstance(obj)) {
            return convertor.convert(obj);
        }
        return null;
    }

    public static <T> T nullizeByCondition(T obj, Condition<T> condition) {
        if (condition.value(obj)) {
            return null;
        }
        return obj;
    }
}

