/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;

public enum LineSeparator {
    LF("\n"),
    CRLF("\r\n"),
    CR("\r");

    private static final Logger LOG;
    private final String mySeparatorString;
    private final byte[] myBytes;

    private LineSeparator(String separatorString) {
        this.mySeparatorString = separatorString;
        this.myBytes = separatorString.getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    public static LineSeparator fromString(String string) {
        for (LineSeparator separator : LineSeparator.values()) {
            if (!separator.getSeparatorString().equals(string)) continue;
            return separator;
        }
        LOG.error("Invalid string for line separator: " + StringUtil.escapeStringCharacters(string));
        return LineSeparator.getSystemLineSeparator();
    }

    public String getSeparatorString() {
        return this.mySeparatorString;
    }

    public byte[] getSeparatorBytes() {
        return this.myBytes;
    }

    public static boolean knownAndDifferent(LineSeparator separator1, LineSeparator separator2) {
        return separator1 != null && separator2 != null && !separator1.equals((Object)separator2);
    }

    public static LineSeparator getSystemLineSeparator() {
        if (SystemInfo.isWindows) {
            return CRLF;
        }
        return LF;
    }

    static {
        LOG = Logger.getInstance(LineSeparator.class);
    }
}

