/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.List;

public class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EventDispatcher");
    private final T myMulticaster;
    private final List<T> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public static <T extends EventListener> EventDispatcher<T> create(Class<T> listenerClass) {
        return new EventDispatcher<T>(listenerClass);
    }

    private EventDispatcher(Class<T> listenerClass) {
        LOG.assertTrue(listenerClass.isInterface(), "listenerClass must be an interface");
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                    String methodName = method.getName();
                    if (methodName.equals("toString")) {
                        return "Multicaster";
                    }
                    if (methodName.equals("hashCode")) {
                        return System.identityHashCode(proxy);
                    }
                    if (methodName.equals("equals")) {
                        return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                    }
                    LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
                    return null;
                }
                EventDispatcher.this.dispatch(method, args);
                return null;
            }
        };
        this.myMulticaster = (EventListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
    }

    public T getMulticaster() {
        return this.myMulticaster;
    }

    private void dispatch(Method method, Object[] args) {
        method.setAccessible(true);
        for (EventListener listener : this.myListeners) {
            try {
                method.invoke((Object)listener, args);
            }
            catch (AbstractMethodError ignored) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof AbstractMethodError) continue;
                LOG.error(cause);
            }
        }
    }

    public void addListener(T listener) {
        this.myListeners.add(listener);
    }

    public void addListener(T listener, Disposable parentDisposable) {
        this.addListener(listener);
        Disposer.register(parentDisposable, new Disposable((EventListener)listener){
            final /* synthetic */ EventListener val$listener;
            {
                this.val$listener = eventListener;
            }

            @Override
            public void dispose() {
                EventDispatcher.this.removeListener(this.val$listener);
            }
        });
    }

    public void removeListener(T listener) {
        this.myListeners.remove(listener);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    public List<T> getListeners() {
        return this.myListeners;
    }
}

