/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.border;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class CustomLineBorder
implements Border {
    private final Color myColor;
    private final Insets myInsets;

    public CustomLineBorder(Color color, Insets insets) {
        this.myColor = color;
        this.myInsets = insets;
    }

    public CustomLineBorder(Color color, int top, int left, int bottom, int right) {
        this(color, new Insets(top, left, bottom, right));
    }

    public CustomLineBorder(Insets insets) {
        this(null, insets);
    }

    public CustomLineBorder(int top, int left, int bottom, int right) {
        this(new Insets(top, left, bottom, right));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Color oldColor = g.getColor();
        g.setColor(this.getColor());
        if (this.myInsets.left > 0) {
            g.fillRect(x, y, x + this.myInsets.left, y + h);
        }
        if (this.myInsets.bottom > 0) {
            g.fillRect(x, y + h - this.myInsets.bottom, x + w, y + h);
        }
        if (this.myInsets.right > 0) {
            g.fillRect(x + w - this.myInsets.right, y, x + w, y + h);
        }
        if (this.myInsets.top > 0) {
            g.fillRect(x, y, x + w, y + this.myInsets.top);
        }
        g.setColor(oldColor);
    }

    protected Color getColor() {
        return this.myColor == null ? UIUtil.getBorderColor() : this.myColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return (Insets)this.myInsets.clone();
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

