/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    private static final String VOWELS = "aeiouy";
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    public static final NotNullFunction<String, String> QUOTER = new NotNullFunction<String, String>(){

        @Override
        public String fun(String s) {
            return "\"" + s + "\"";
        }
    };
    public static final NotNullFunction<String, String> SINGLE_QUOTER = new NotNullFunction<String, String>(){

        @Override
        public String fun(String s) {
            return "'" + s + "'";
        }
    };
    public static Function<String, String> TRIMMER = new Function<String, String>(){

        @Override
        public String fun(String s) {
            return StringUtil.trim(s);
        }
    };
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    private static final String[] REPLACES_REFS = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;"};
    private static final String[] REPLACES_DISP = new String[]{"<", ">", "&", "'", "\""};
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-eA-E]{4}");

    public static List<String> getWordsInStringLongestFirst(String find) {
        List<String> words = StringUtil.getWordsIn(find);
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return words;
    }

    public static String escapePattern(String text) {
        return StringUtil.replace(StringUtil.replace(text, "'", "''"), "{", "'{'");
    }

    public static <T> Function<T, String> createToStringFunction(Class<T> cls) {
        return new Function<T, String>(){

            @Override
            public String fun(T o) {
                return o.toString();
            }
        };
    }

    public static String replace(String text, String oldS, String newS) {
        return StringUtil.replace(text, oldS, newS, false);
    }

    public static String replaceIgnoreCase(String text, String oldS, String newS) {
        return StringUtil.replace(text, oldS, newS, true);
    }

    public static void replaceChar(char[] buffer, char oldChar, char newChar, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = buffer[i];
            if (c != oldChar) continue;
            buffer[i] = newChar;
        }
    }

    public static String replaceChar(String buffer, char oldChar, char newChar) {
        StringBuilder newBuffer = null;
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == oldChar) {
                if (newBuffer == null) {
                    newBuffer = new StringBuilder(buffer.length());
                    newBuffer.append(buffer, 0, i);
                }
                newBuffer.append(newChar);
                continue;
            }
            if (newBuffer == null) continue;
            newBuffer.append(c);
        }
        return newBuffer == null ? buffer : newBuffer.toString();
    }

    public static String replace(String text, String oldS, String newS, boolean ignoreCase) {
        if (text.length() < oldS.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int index;
            int n = index = ignoreCase ? StringUtil.indexOfIgnoreCase(text, oldS, i) : text.indexOf(oldS, i);
            if (index < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            if (newText == null) {
                if (text.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text.length() - i);
            }
            newText.append(text, i, index);
            newText.append(newS);
            i = index + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    public static int indexOfIgnoreCase(String where, String what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String where, char what, int fromIndex) {
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(String where, String what) {
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    public static String stripHtml(String html, boolean convertBreaks) {
        if (convertBreaks) {
            html = html.replaceAll("<br/?>", "\n\n");
        }
        return html.replaceAll("<(.|\n)*?>", "");
    }

    public static String toLowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static String getPackageName(String fqName) {
        return StringUtil.getPackageName(fqName, '.');
    }

    public static String getPackageName(String fqName, char separator) {
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx >= 0) {
            return fqName.substring(0, lastPointIdx);
        }
        return "";
    }

    public static int getLineBreakCount(CharSequence text) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public static boolean containsLineBreak(CharSequence text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    public static String escapeLineBreak(String text) {
        StringBuilder buffer = new StringBuilder(text.length());
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static boolean endsWithLineBreak(CharSequence text) {
        int len = text.length();
        return len > 0 && StringUtil.isLineBreak(text.charAt(len - 1));
    }

    public static int lineColToOffset(CharSequence text, int line, int col) {
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text.length()) {
                return -1;
            }
            char c = text.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text.length() - 1 && text.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    public static int offsetToLineNumber(CharSequence text, int offset) {
        int curLine = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text.length()) {
                return -1;
            }
            char c = text.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset >= text.length() - 1 || text.charAt(curOffset + 1) != '\n') continue;
            ++curOffset;
        }
        return curLine;
    }

    public static int difference(String s1, String s2) {
        int i;
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    public static String wordsToBeginFromUpperCase(String s) {
        return StringUtil.fixCapitalization(s, ourPrepositions, true);
    }

    public static String wordsToBeginFromLowerCase(String s) {
        return StringUtil.fixCapitalization(s, ourPrepositions, false);
    }

    public static String toTitleCase(String s) {
        return StringUtil.fixCapitalization(s, ArrayUtil.EMPTY_STRING_ARRAY, true);
    }

    private static String fixCapitalization(String s, String[] prepositions, boolean title) {
        StringBuilder buffer = null;
        for (int i = 0; i < s.length(); ++i) {
            int j;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
            }
            if (StringUtil.isPreposition(s, i, j - 1, prepositions)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(i, title ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        if (buffer == null) {
            return s;
        }
        return buffer.toString();
    }

    public static boolean isPreposition(String s, int firstChar, int lastChar) {
        return StringUtil.isPreposition(s, firstChar, lastChar, ourPrepositions);
    }

    public static boolean isPreposition(String s, int firstChar, int lastChar, String[] prepositions) {
        for (String preposition : prepositions) {
            boolean found = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == preposition.charAt(j)) continue;
                    found = false;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static NotNullFunction<String, String> escaper(final boolean escapeSlash, final String additionalChars) {
        return new NotNullFunction<String, String>(){

            @Override
            public String fun(String dom) {
                StringBuilder builder = new StringBuilder(dom.length());
                StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
                return builder.toString();
            }
        };
    }

    public static void escapeStringCharacters(int length, String str, StringBuilder buffer) {
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    public static StringBuilder escapeStringCharacters(int length, String str, String additionalChars, StringBuilder buffer) {
        return StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
    }

    public static StringBuilder escapeStringCharacters(int length, String str, String additionalChars, boolean escapeSlash, StringBuilder buffer) {
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (!StringUtil.isPrintableUnicode(ch)) {
                        CharSequence hexCode = StringUtilRt.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        return buffer;
    }

    private static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    public static String escapeStringCharacters(String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        return buffer.toString();
    }

    public static String escapeCharCharacters(String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        return buffer.toString();
    }

    public static String unescapeStringCharacters(String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        return buffer.toString();
    }

    private static boolean isQuoteAt(String s, int ind) {
        char ch = s.charAt(ind);
        return ch == '\'' || ch == '\"';
    }

    public static boolean isQuotedString(String s) {
        return s.length() > 1 && StringUtil.isQuoteAt(s, 0) && s.charAt(0) == s.charAt(s.length() - 1);
    }

    public static String unquoteString(String s) {
        if (StringUtil.isQuotedString(s)) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String unquoteString(String s, char quotationChar) {
        if (s.length() > 1 && quotationChar == s.charAt(0) && quotationChar == s.charAt(s.length() - 1)) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String quoteReplacement(String s) {
        boolean needReplacements = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '$') continue;
            needReplacements = true;
            break;
        }
        if (!needReplacements) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() * 6 / 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void unescapeStringCharacters(int length, String s, StringBuilder buffer) {
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    public static String pluralize(String suggestion) {
        if (suggestion.endsWith("Child") || suggestion.endsWith("child")) {
            return suggestion + "ren";
        }
        if (suggestion.equals("this")) {
            return "these";
        }
        if (suggestion.equals("This")) {
            return "These";
        }
        if (StringUtil.endsWithIgnoreCase(suggestion, "es")) {
            return suggestion;
        }
        if (StringUtil.endsWithIgnoreCase(suggestion, "s") || StringUtil.endsWithIgnoreCase(suggestion, "x") || StringUtil.endsWithIgnoreCase(suggestion, "ch")) {
            return suggestion + "es";
        }
        int len = suggestion.length();
        if (StringUtil.endsWithIgnoreCase(suggestion, "y") && len > 1 && !StringUtil.isVowel(StringUtil.toLowerCase(suggestion.charAt(len - 2)))) {
            return suggestion.substring(0, len - 1) + "ies";
        }
        return suggestion + "s";
    }

    public static String capitalizeWords(String text, boolean allWords) {
        return StringUtil.capitalizeWords(text, " \t\n\r\f", allWords, false);
    }

    public static String capitalizeWords(String text, String tokenizerDelim, boolean allWords, boolean leaveOriginalDelims) {
        java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(text, tokenizerDelim, leaveOriginalDelims);
        StringBuilder out = new StringBuilder(text.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelims && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        return out.toString();
    }

    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    public static boolean isVowel(char c) {
        return VOWELS.indexOf(c) >= 0;
    }

    public static String capitalize(String s) {
        if (s.isEmpty()) {
            return s;
        }
        if (s.length() == 1) {
            return ((Object)StringUtilRt.toUpperCase(s)).toString();
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static boolean isCapitalized(String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    public static String capitalizeWithJavaBeanConvention(String s) {
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return StringUtil.capitalize(s);
    }

    public static int stringHashCode(CharSequence chars) {
        if (chars instanceof String) {
            return chars.hashCode();
        }
        if (chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        if (chars instanceof CharArrayCharSequence) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    public static int stringHashCode(CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    public static int stringHashCodeInsensitive(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars[off]);
        }
        return h;
    }

    public static int stringHashCodeInsensitive(CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    public static int stringHashCodeInsensitive(CharSequence chars) {
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    public static int stringHashCodeIgnoreWhitespaces(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars[off];
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    public static int stringHashCodeIgnoreWhitespaces(CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars.charAt(off);
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    public static int stringHashCodeIgnoreWhitespaces(CharSequence chars) {
        return StringUtil.stringHashCodeIgnoreWhitespaces(chars, 0, chars.length());
    }

    public static boolean startsWithConcatenation(String string, String ... prefixes) {
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    public static boolean startsWithConcatenationOf(String string, String firstPrefix, String secondPrefix) {
        return StringUtil.startsWithConcatenation(string, firstPrefix, secondPrefix);
    }

    public static boolean startsWithConcatenationOf(String string, String firstPrefix, String secondPrefix, String thirdPrefix) {
        return StringUtil.startsWithConcatenation(string, firstPrefix, secondPrefix, thirdPrefix);
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static String trimEnd(String s, String suffix) {
        if (s.endsWith(suffix)) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public static String trimLog(String text, int limit) {
        if (limit > 5 && text.length() > limit) {
            return text.substring(0, limit - 5) + " ...\n";
        }
        return text;
    }

    public static String trimLeading(String string) {
        return ((Object)StringUtil.trimLeading((CharSequence)string)).toString();
    }

    public static CharSequence trimLeading(CharSequence string) {
        int index;
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        return string.subSequence(index, string.length());
    }

    public static String trimLeading(String string, char symbol) {
        int index;
        for (index = 0; index < string.length() && string.charAt(index) == symbol; ++index) {
        }
        return string.substring(index);
    }

    public static String trimTrailing(String string) {
        return ((Object)StringUtil.trimTrailing((CharSequence)string)).toString();
    }

    public static CharSequence trimTrailing(CharSequence string) {
        int index;
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        return string.subSequence(0, index + 1);
    }

    public static boolean startsWithChar(CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    public static boolean endsWithChar(CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    public static String trimStart(String s, String prefix) {
        if (s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    public static String pluralize(String base, int n) {
        if (n == 1) {
            return base;
        }
        return StringUtil.pluralize(base);
    }

    public static void repeatSymbol(Appendable buffer, char symbol, int times) {
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static String defaultIfEmpty(String value, String defaultValue) {
        return StringUtil.isEmpty(value) ? defaultValue : value;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String notNullize(String s) {
        return StringUtil.notNullize(s, "");
    }

    public static String notNullize(String s, String defaultValue) {
        return s == null ? defaultValue : s;
    }

    public static String nullize(String s) {
        return StringUtil.nullize(s, false);
    }

    public static String nullize(String s, boolean nullizeSpaces) {
        if (nullizeSpaces ? StringUtil.isEmptyOrSpaces(s) : StringUtil.isEmpty(s)) {
            return null;
        }
        return s;
    }

    public static boolean isEmptyOrSpaces(String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    public static boolean isEmptyOrSpaces(CharSequence s) {
        if (StringUtil.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    public static String getThrowableText(Throwable aThrowable) {
        return ExceptionUtil.getThrowableText(aThrowable);
    }

    public static String getThrowableText(Throwable aThrowable, String stackFrameSkipPattern) {
        return ExceptionUtil.getThrowableText(aThrowable, stackFrameSkipPattern);
    }

    public static String getMessage(Throwable e) {
        return ExceptionUtil.getMessage(e);
    }

    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        return StringFactory.createShared(buffer);
    }

    public static String repeat(String s, int count) {
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static List<String> splitHonorQuotes(String s, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(s.length());
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && !inQuotes) {
                if (builder.length() <= 0) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i > 0 && s.charAt(i - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        return result;
    }

    public static List<String> split(String s, String separator) {
        return StringUtil.split(s, separator, true);
    }

    public static List<CharSequence> split(CharSequence s, CharSequence separator) {
        return StringUtil.split(s, separator, true, true);
    }

    public static List<String> split(String s, String separator, boolean excludeSeparator) {
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    public static List<String> split(String s, String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    public static List<CharSequence> split(CharSequence s, CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (separator.length() == 0) {
            return Collections.singletonList(s);
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result.add(s.subSequence(pos, s.length()));
        }
        return result;
    }

    public static Iterable<String> tokenize(String s, String separators) {
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<String> tokenize(final java.util.StringTokenizer tokenizer) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static List<String> getWordsIn(String text) {
        SmartList<String> result = null;
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1 && start != -1) {
                if (result == null) {
                    result = new SmartList();
                }
                result.add(text.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result == null) {
                result = new SmartList<String>();
            }
            result.add(text.substring(start, i));
            start = -1;
        }
        if (result == null) {
            return ContainerUtil.emptyList();
        }
        return result;
    }

    public static List<TextRange> getWordIndicesIn(String text) {
        SmartList<TextRange> result = new SmartList<TextRange>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1 && start != -1) {
                result.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(new TextRange(start, i));
            start = -1;
        }
        return result;
    }

    public static String join(String[] strings, String separator) {
        return StringUtil.join(strings, 0, strings.length, separator);
    }

    public static String join(String[] strings, int startIndex, int endIndex, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        return result.toString();
    }

    public static String[] zip(String[] strings1, String[] strings2, String separator) {
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings1[i] + separator + strings2[i];
        }
        return result;
    }

    public static String[] surround(String[] strings1, String prefix, String suffix) {
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strings1[i] + suffix;
        }
        return result;
    }

    public static <T> String join(T[] items, Function<T, String> f, String separator) {
        return StringUtil.join(Arrays.asList(items), f, separator);
    }

    public static <T> String join(Collection<? extends T> items, Function<? super T, String> f, String separator) {
        if (items.isEmpty()) {
            return "";
        }
        return StringUtil.join(items, f, separator);
    }

    public static String join(Iterable<?> items, String separator) {
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(item).append(separator);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - separator.length());
        }
        return result.toString();
    }

    public static <T> String join(Iterable<? extends T> items, Function<? super T, String> f, String separator) {
        StringBuilder result = new StringBuilder();
        for (T item : items) {
            String string = f.fun(item);
            if (string == null || string.isEmpty()) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
        return result.toString();
    }

    public static String join(Collection<String> strings, String separator) {
        if (strings.size() <= 1) {
            return StringUtil.notNullize(ContainerUtil.getFirstItem(strings));
        }
        StringBuilder result = new StringBuilder();
        StringUtil.join(strings, separator, result);
        return result.toString();
    }

    public static void join(Collection<String> strings, String separator, StringBuilder result) {
        boolean isFirst = true;
        for (String string : strings) {
            if (string == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(separator);
            }
            result.append(string);
        }
    }

    public static String join(int[] strings, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        return result.toString();
    }

    public static String join(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static String stripQuotesAroundValue(String text) {
        int len = text.length();
        if (len > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                return text.substring(from, to);
            }
        }
        return text;
    }

    public static String formatFileSize(long fileSize) {
        return StringUtil.formatValue(fileSize, null, new String[]{"B", "K", "M", "G", "T", "P", "E"}, new long[]{1000L, 1000L, 1000L, 1000L, 1000L, 1000L});
    }

    public static String formatDuration(long duration) {
        return StringUtil.formatValue(duration, " ", new String[]{"ms", "s", "m", "h", "d", "w", "mo", "yr", "c", "ml", "ep"}, new long[]{1000L, 60L, 60L, 24L, 7L, 4L, 12L, 100L, 10L, 10000L});
    }

    private static String formatValue(long value, String partSeparator, String[] units, long[] multipliers) {
        int i;
        StringBuilder sb = new StringBuilder();
        long count = value;
        long remainder = 0L;
        for (i = 0; i < units.length; ++i) {
            long multiplier;
            long l = multiplier = i < multipliers.length ? multipliers[i] : -1L;
            if (multiplier == -1L || count < multiplier) break;
            remainder = count % multiplier;
            count /= multiplier;
            if (partSeparator == null || remainder == 0L && sb.length() <= 0) continue;
            sb.insert(0, units[i]).insert(0, remainder).insert(0, partSeparator);
        }
        if (partSeparator != null || remainder == 0L) {
            sb.insert(0, units[i]).insert(0, count);
        } else if (remainder > 0L) {
            sb.append(String.format(Locale.US, "%.2f", (double)count + (double)remainder / (double)multipliers[i - 1])).append(units[i]);
        }
        return sb.toString();
    }

    public static String unpluralize(String name) {
        if (name.endsWith("sses") || name.endsWith("shes") || name.endsWith("ches") || name.endsWith("xes")) {
            return name.substring(0, name.length() - 2);
        }
        if (name.endsWith("ses")) {
            return name.substring(0, name.length() - 1);
        }
        if (name.endsWith("ies")) {
            if (name.endsWith("cookies") || name.endsWith("Cookies")) {
                return name.substring(0, name.length() - "ookies".length()) + "ookie";
            }
            return name.substring(0, name.length() - 3) + "y";
        }
        if (name.endsWith("leaves") || name.endsWith("Leaves")) {
            return name.substring(0, name.length() - "eaves".length()) + "eaf";
        }
        String result = StringUtil.stripEnding(name, "s");
        if (result != null) {
            return result;
        }
        if (name.endsWith("children")) {
            return name.substring(0, name.length() - "children".length()) + "child";
        }
        if (name.endsWith("Children") && name.length() > "Children".length()) {
            return name.substring(0, name.length() - "Children".length()) + "Child";
        }
        return null;
    }

    private static String stripEnding(String name, String ending) {
        if (name.endsWith(ending)) {
            if (name.equals(ending)) {
                return name;
            }
            return name.substring(0, name.length() - 1);
        }
        return null;
    }

    public static boolean containsAlphaCharacters(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyChar(String value, String chars) {
        if (chars.length() > value.length()) {
            return StringUtil.containsAnyChar(value, chars, 0, value.length());
        }
        return StringUtil.containsAnyChar(chars, value, 0, chars.length());
    }

    public static boolean containsAnyChar(String value, String chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsChar(String value, char ch) {
        return value.indexOf(ch) >= 0;
    }

    public static String firstLetterToUpperCase(String displayString) {
        if (displayString == null || displayString.isEmpty()) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        char[] buffer = displayString.toCharArray();
        buffer[0] = uppedFirstChar;
        return StringFactory.createShared(buffer);
    }

    public static String strip(String s, CharFilter filter) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public static List<String> findMatches(String s, Pattern pattern) {
        return StringUtil.findMatches(s, pattern, 1);
    }

    public static List<String> findMatches(String s, Pattern pattern, int groupIndex) {
        SmartList<String> result = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result.add(group);
        }
        return result;
    }

    public static int findFirst(CharSequence s, CharFilter filter) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    public static String replaceSubstring(String string, TextRange range, String replacement) {
        return range.replace(string, replacement);
    }

    public static boolean startsWithWhitespace(String text) {
        return !text.isEmpty() && Character.isWhitespace(text.charAt(0));
    }

    public static boolean isChar(CharSequence seq, int index, char c) {
        return index >= 0 && index < seq.length() && seq.charAt(index) == c;
    }

    public static boolean startsWith(CharSequence text, CharSequence prefix) {
        int l2;
        int l1 = text.length();
        if (l1 < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence text, int startIndex, CharSequence prefix) {
        int l2;
        int l1 = text.length() - startIndex;
        if (l1 < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(CharSequence text, CharSequence suffix) {
        int l2;
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    public static String commonPrefix(String s1, String s2) {
        return s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
    }

    public static int commonPrefixLength(CharSequence s1, CharSequence s2) {
        int i;
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return i;
    }

    public static String commonSuffix(String s1, String s2) {
        return s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
    }

    public static int commonSuffixLength(CharSequence s1, CharSequence s2) {
        int i;
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    public static boolean contains(CharSequence s, int start, int end, char c) {
        return StringUtil.indexOf(s, c, start, end) >= 0;
    }

    public static boolean containsWhitespaces(CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(CharSequence s, char c) {
        return StringUtil.indexOf(s, c, 0, s.length());
    }

    public static int indexOf(CharSequence s, char c, int start) {
        return StringUtil.indexOf(s, c, start, s.length());
    }

    public static int indexOf(CharSequence s, char c, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(CharSequence sequence, CharSequence infix) {
        return StringUtil.indexOf(sequence, infix) >= 0;
    }

    public static int indexOf(CharSequence sequence, CharSequence infix) {
        return StringUtil.indexOf(sequence, infix, 0);
    }

    public static int indexOf(CharSequence sequence, CharSequence infix, int start) {
        for (int i = start; i <= sequence.length() - infix.length(); ++i) {
            if (!StringUtil.startsWith(sequence, i, infix)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence s, char c, int start, int end, boolean caseSensitive) {
        for (int i = start; i < end; ++i) {
            if (!StringUtil.charsMatch(s.charAt(i), c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] s, char c, int start, int end, boolean caseSensitive) {
        for (int i = start; i < end; ++i) {
            if (!StringUtil.charsMatch(s[i], c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfSubstringEnd(String text, String subString) {
        int i = text.indexOf(subString);
        if (i == -1) {
            return -1;
        }
        return i + subString.length();
    }

    public static int indexOfAny(String s, String chars) {
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    public static int indexOfAny(CharSequence s, String chars) {
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    public static int indexOfAny(String s, String chars, int start, int end) {
        return StringUtil.indexOfAny((CharSequence)s, chars, start, end);
    }

    public static int indexOfAny(CharSequence s, String chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static String substringBefore(String text, String subString) {
        int i = text.indexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(0, i);
    }

    public static String substringAfter(String text, String subString) {
        int i = text.indexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    public static int lastIndexOf(CharSequence s, char c, int start, int end) {
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    public static String first(String text, int maxLength, boolean appendEllipsis) {
        return text.length() > maxLength ? text.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text;
    }

    public static CharSequence first(CharSequence text, int length, boolean appendEllipsis) {
        return text.length() > length ? text.subSequence(0, length) + (appendEllipsis ? "..." : "") : text;
    }

    public static CharSequence last(CharSequence text, int length, boolean prependEllipsis) {
        return text.length() > length ? (prependEllipsis ? "..." : "") + text.subSequence(text.length() - length, text.length()) : text;
    }

    public static String escapeChar(String str, char character) {
        return StringUtil.escapeChars(str, character);
    }

    public static String escapeChars(String str, char ... character) {
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        return buf.toString();
    }

    private static void escapeChar(StringBuilder buf, char character) {
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    public static String escapeQuotes(String str) {
        return StringUtil.escapeChar(str, '\"');
    }

    public static void escapeQuotes(StringBuilder buf) {
        StringUtil.escapeChar(buf, '\"');
    }

    public static String escapeSlashes(String str) {
        return StringUtil.escapeChar(str, '/');
    }

    public static String escapeBackSlashes(String str) {
        return StringUtil.escapeChar(str, '\\');
    }

    public static void escapeSlashes(StringBuilder buf) {
        StringUtil.escapeChar(buf, '/');
    }

    public static String unescapeSlashes(String str) {
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '/');
        return buf.toString();
    }

    public static String unescapeBackSlashes(String str) {
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        return buf.toString();
    }

    public static String unescapeChar(String str, char unescapeChar) {
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        return buf.toString();
    }

    private static void unescapeChar(StringBuilder buf, String str, char unescapeChar) {
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(StringBuilder builder) {
        StringUtil.quote(builder, '\"');
    }

    public static void quote(StringBuilder builder, char quotingChar) {
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    public static String wrapWithDoubleQuote(String str) {
        return '\"' + str + "\"";
    }

    public static String unescapeXml(String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_REFS, REPLACES_DISP);
    }

    public static String escapeXml(String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_DISP, REPLACES_REFS);
    }

    public static String htmlEmphasize(String text) {
        return "<b><code>" + StringUtil.escapeXml(text) + "</code></b>";
    }

    public static String escapeToRegexp(String text) {
        StringBuilder result = new StringBuilder(text.length());
        return StringUtil.escapeToRegexp(text, result).toString();
    }

    public static StringBuilder escapeToRegexp(CharSequence text, StringBuilder builder) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            builder.append('\\').append(c);
        }
        return builder;
    }

    public static boolean isNotEscapedBackslash(char[] chars, int startOffset, int backslashOffset) {
        if (chars[backslashOffset] != '\\') {
            return false;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = chars[i] == '\\' ? !escaped : false;
        }
        return !escaped;
    }

    public static boolean isNotEscapedBackslash(CharSequence text, int startOffset, int backslashOffset) {
        if (text.charAt(backslashOffset) != '\\') {
            return false;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text.charAt(i) == '\\' ? !escaped : false;
        }
        return !escaped;
    }

    public static String replace(String text, String[] from, String[] to) {
        StringBuilder result = new StringBuilder(text.length());
        block0: for (int i = 0; i < text.length(); ++i) {
            for (int j = 0; j < from.length; ++j) {
                String toReplace = from[j];
                String replaceWith = to[j];
                int len = toReplace.length();
                if (!text.regionMatches(i, toReplace, 0, len)) continue;
                result.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            result.append(text.charAt(i));
        }
        return result.toString();
    }

    public static String[] filterEmptyStrings(String[] strings) {
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            return strings;
        }
        String[] result = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count = 0;
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            result[count++] = string;
        }
        return result;
    }

    public static int countNewLines(CharSequence text) {
        return StringUtil.countChars(text, '\n');
    }

    public static int countChars(CharSequence text, char c) {
        return StringUtil.countChars(text, c, 0, false);
    }

    public static int countChars(CharSequence text, char c, int offset, boolean continuous) {
        int count = 0;
        for (int i = offset; i < text.length(); ++i) {
            if (text.charAt(i) == c) {
                ++count;
                continue;
            }
            if (continuous) break;
        }
        return count;
    }

    public static String capitalsOnly(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    public static String joinOrNull(String ... args) {
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    public static String getPropertyName(String methodName) {
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || StringUtil.isJavaIdentifierStart(c);
    }

    public static boolean isJavaIdentifier(String text) {
        int len = text.length();
        if (len == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String escapeProperty(String input, boolean isKey) {
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        return escaped.toString();
    }

    public static String getQualifiedName(String packageName, String className) {
        if (packageName == null || packageName.isEmpty()) {
            return className;
        }
        return packageName + '.' + className;
    }

    public static String formatVersionToMajorMinorPatchString(String version) {
        if (version.matches("(\\d+\\.)*\\d+")) {
            String[] parts = version.split("\\.", 3);
            String major = parts.length > 0 ? parts[0] : "0";
            String minor = parts.length > 1 ? parts[1] : "0";
            String patch = parts.length > 2 ? parts[2] : "0";
            version = major + '.' + minor + '.' + patch;
        }
        return version;
    }

    public static int compareVersionNumbers(String v1, String v2) {
        String[] parts;
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        boolean left = part1.length > idx;
        String[] stringArray = parts = left ? part1 : part2;
        while (idx < parts.length) {
            String p = parts[idx];
            int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
            if (cmp != 0) {
                return left ? cmp : -cmp;
            }
            ++idx;
        }
        return 0;
    }

    public static int getOccurrenceCount(String text, char c) {
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(c, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    public static int getOccurrenceCount(String text, String s) {
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    public static String fixVariableNameDerivedFromPropertyName(String name) {
        if (StringUtil.isEmptyOrSpaces(name)) {
            return name;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            return "an" + Character.toUpperCase(c) + name.substring(1);
        }
        return "a" + Character.toUpperCase(c) + name.substring(1);
    }

    public static String sanitizeJavaIdentifier(String name) {
        StringBuilder result = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result.append("_");
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static void assertValidSeparators(CharSequence s) {
        int i;
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            LOG.error("Wrong line separators: '" + context + "' at offset " + slashRIndex);
        }
    }

    public static String tail(String s, int idx) {
        return idx >= s.length() ? "" : s.substring(idx, s.length());
    }

    public static String[] splitByLines(String string) {
        return StringUtil.splitByLines(string, true);
    }

    public static String[] splitByLines(String string, boolean excludeEmptyStrings) {
        return (excludeEmptyStrings ? EOL_SPLIT_PATTERN : EOL_SPLIT_PATTERN_WITH_EMPTY).split(string);
    }

    public static String[] splitByLinesDontTrim(String string) {
        return EOL_SPLIT_DONT_TRIM_PATTERN.split(string);
    }

    public static String[] splitByLinesKeepSeparators(String string) {
        return EOL_SPLIT_KEEP_SEPARATORS.split(string);
    }

    public static List<Pair<String, Integer>> getWordsWithOffset(String s) {
        ArrayList<Pair<String, Integer>> res = ContainerUtil.newArrayList();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                res.add(Pair.create(name.toString(), startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        return res;
    }

    public static int naturalCompare(String string1, String string2) {
        return StringUtil.naturalCompare(string1, string2, false);
    }

    private static int naturalCompare(String string1, String string2, boolean caseSensitive) {
        int j;
        if (string1 == string2) {
            return 0;
        }
        if (string1 == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        int string1Length = string1.length();
        int string2Length = string2.length();
        int i = 0;
        for (j = 0; i < string1Length && j < string2Length; ++i, ++j) {
            int diff2;
            int diff1;
            char ch1 = string1.charAt(i);
            char ch2 = string2.charAt(j);
            if ((StringUtil.isDecimalDigit(ch1) || ch1 == ' ') && (StringUtil.isDecimalDigit(ch2) || ch2 == ' ')) {
                int startNum1 = i;
                while ((ch1 == ' ' || ch1 == '0') && ++startNum1 < string1Length) {
                    ch1 = string1.charAt(startNum1);
                }
                int startNum2 = j;
                while ((ch2 == ' ' || ch2 == '0') && ++startNum2 < string2Length) {
                    ch2 = string2.charAt(startNum2);
                }
                j = startNum2;
                for (i = startNum1; i < string1Length && StringUtil.isDecimalDigit(string1.charAt(i)); ++i) {
                }
                while (j < string2Length && StringUtil.isDecimalDigit(string2.charAt(j))) {
                    ++j;
                }
                int lengthDiff = i - startNum1 - (j - startNum2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                while (startNum1 < i) {
                    int diff = string1.charAt(startNum1) - string2.charAt(startNum2);
                    if (diff != 0) {
                        return diff;
                    }
                    ++startNum1;
                    ++startNum2;
                }
                --i;
                --j;
                continue;
            }
            if (caseSensitive) {
                return ch1 - ch2;
            }
            if (ch1 == ch2 || (diff1 = StringUtilRt.toUpperCase(ch1) - StringUtilRt.toUpperCase(ch2)) == 0 || (diff2 = StringUtilRt.toLowerCase(ch1) - StringUtilRt.toLowerCase(ch2)) == 0) continue;
            return diff2;
        }
        if (i < string1Length) {
            return 1;
        }
        if (j < string2Length) {
            return -1;
        }
        if (!caseSensitive && string1Length == string2Length) {
            return StringUtil.naturalCompare(string1, string2, true);
        }
        return string1Length - string2Length;
    }

    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static int compare(String s1, String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    public static int comparePairs(String s1, String t1, String s2, String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    public static int hashCode(CharSequence s) {
        return StringUtil.stringHashCode(s);
    }

    public static boolean equals(CharSequence s1, CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(CharSequence s1, CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (StringUtil.charsMatch(s1.charAt(i), s2.charAt(i), true)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreWhitespaces(CharSequence s1, CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringUtil.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringUtil.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringUtil.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringUtil.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    public static boolean equalsTrimWhitespaces(CharSequence s1, CharSequence s2) {
        char c;
        int start1;
        int end1 = s1.length();
        int start2 = 0;
        int end2 = s2.length();
        for (start1 = 0; start1 < end1 && StringUtil.isWhiteSpace(c = s1.charAt(start1)); ++start1) {
        }
        while (start1 < end1 && StringUtil.isWhiteSpace(c = s1.charAt(end1 - 1))) {
            --end1;
        }
        while (start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(start2))) {
            ++start2;
        }
        while (start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(end2 - 1))) {
            --end2;
        }
        CharSequenceSubSequence ts1 = new CharSequenceSubSequence(s1, start1, end1);
        CharSequenceSubSequence ts2 = new CharSequenceSubSequence(s2, start2, end2);
        return StringUtil.equals(ts1, ts2);
    }

    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    public static String formatLinks(String message) {
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z0-9\\./\\-\\+]+");
        StringBuffer result = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result);
        return result.toString();
    }

    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    public static String shortenTextWithEllipsis(String text, int maxLength, int suffixLength) {
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, false);
    }

    public static String trimMiddle(String text, int maxLength) {
        return StringUtil.shortenTextWithEllipsis(text, maxLength, maxLength >> 1, true);
    }

    public static String shortenTextWithEllipsis(String text, int maxLength, int suffixLength, String symbol) {
        int textLength = text.length();
        if (textLength > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength > 0);
            return text.substring(0, prefixLength) + symbol + text.substring(textLength - suffixLength);
        }
        return text;
    }

    public static String shortenTextWithEllipsis(String text, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        String symbol = useEllipsisSymbol ? "\u2026" : "...";
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, symbol);
    }

    public static String shortenPathWithEllipsis(String path, int maxLength, boolean useEllipsisSymbol) {
        return StringUtil.shortenTextWithEllipsis(path, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
    }

    public static String shortenPathWithEllipsis(String path, int maxLength) {
        return StringUtil.shortenPathWithEllipsis(path, maxLength, false);
    }

    public static boolean charsEqual(char a, char b, boolean ignoreCase) {
        return ignoreCase ? StringUtil.charsEqualIgnoreCase(a, b) : a == b;
    }

    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtilRt.charsEqualIgnoreCase(a, b);
    }

    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    public static String toUpperCase(String a) {
        return ((Object)StringUtilRt.toUpperCase(a)).toString();
    }

    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    public static LineSeparator detectSeparators(CharSequence text) {
        int index = StringUtil.indexOfAny(text, "\n\r");
        if (index == -1) {
            return null;
        }
        if (StringUtil.startsWith(text, index, "\r\n")) {
            return LineSeparator.CRLF;
        }
        if (text.charAt(index) == '\r') {
            return LineSeparator.CR;
        }
        if (text.charAt(index) == '\n') {
            return LineSeparator.LF;
        }
        throw new IllegalStateException();
    }

    public static String convertLineSeparators(String text) {
        return StringUtilRt.convertLineSeparators(text);
    }

    public static String convertLineSeparators(String text, boolean keepCarriageReturn) {
        return StringUtilRt.convertLineSeparators(text, keepCarriageReturn);
    }

    public static String convertLineSeparators(String text, String newSeparator) {
        return StringUtilRt.convertLineSeparators(text, newSeparator);
    }

    public static String convertLineSeparators(String text, String newSeparator, int[] offsetsToKeep) {
        return StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep);
    }

    public static String convertLineSeparators(String text, String newSeparator, int[] offsetsToKeep, boolean keepCarriageReturn) {
        return StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep, keepCarriageReturn);
    }

    public static int parseInt(String string, int defaultValue) {
        return StringUtilRt.parseInt(string, defaultValue);
    }

    public static double parseDouble(String string, double defaultValue) {
        return StringUtilRt.parseDouble(string, defaultValue);
    }

    public static boolean parseBoolean(String string, boolean defaultValue) {
        return StringUtilRt.parseBoolean(string, defaultValue);
    }

    public static String getShortName(Class aClass) {
        return StringUtilRt.getShortName(aClass);
    }

    public static String getShortName(String fqName) {
        return StringUtilRt.getShortName(fqName);
    }

    public static String getShortName(String fqName, char separator) {
        return StringUtilRt.getShortName(fqName, separator);
    }

    public static CharSequence newBombedCharSequence(CharSequence sequence, long delay) {
        final long myTime = System.currentTimeMillis() + delay;
        return new BombedCharSequence(sequence){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    public static boolean trimEnd(StringBuilder buffer, CharSequence end) {
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    public static boolean isBetween(String string, String smallPart, String bigPart) {
        String s = string.toLowerCase();
        return s.startsWith(smallPart.toLowerCase()) && bigPart.toLowerCase().startsWith(s);
    }

    public static String getShortened(String s, int maxWidth) {
        int index;
        String aWord;
        int i;
        int length = s.length();
        if (StringUtil.isEmpty(s) || length <= maxWidth) {
            return s;
        }
        ArrayList<String> words = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (i == length - 1) {
                builder.append(ch);
                words.add(builder.toString());
                builder.delete(0, builder.length());
                continue;
            }
            if (i > 0 && (ch == '/' || ch == '\\' || ch == '.' || ch == '-' || Character.isUpperCase(ch))) {
                words.add(builder.toString());
                builder.delete(0, builder.length());
            }
            builder.append(ch);
        }
        for (i = 0; i < words.size(); ++i) {
            String word = (String)words.get(i);
            if (i >= words.size() - 1 || word.length() != 1) continue;
            words.remove(i);
            words.set(i, word + (String)words.get(i));
        }
        int removedLength = 0;
        String toPaste = "...";
        do {
            index = Math.max(0, (words.size() - 1) / 2);
            aWord = (String)words.get(index);
            words.remove(index);
            int toCut = length - removedLength - maxWidth + 3;
            if (words.size() >= 2 && (toCut >= aWord.length() - 2 || removedLength != 0)) continue;
            int pos = (aWord.length() - toCut) / 2;
            toPaste = aWord.substring(0, pos) + "..." + aWord.substring(pos + toCut);
            break;
        } while (length - (removedLength += aWord.length()) > maxWidth - 3);
        for (int i2 = 0; i2 < Math.max(1, words.size()); ++i2) {
            String word;
            String string = word = words.isEmpty() ? "" : (String)words.get(i2);
            if (i2 == index || words.size() == 1) {
                builder.append(toPaste);
            }
            builder.append(word);
        }
        return builder.toString().replaceAll("\\.{4,}", "...");
    }

    public static boolean hasUpperCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeEscapeSequences(String text) {
        if (text == null) {
            return null;
        }
        Matcher matcher = UNICODE_CHAR.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        matcher.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text.length());
        while (matcher.find()) {
            sb.append(text.substring(lastEnd, matcher.start()));
            char c = (char)Integer.parseInt(matcher.group().substring(2), 16);
            sb.append(c);
            lastEnd = matcher.end();
        }
        sb.append(text.substring(lastEnd, text.length()));
        return sb.toString();
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i = 0;

        public BombedCharSequence(CharSequence sequence) {
            this.delegate = sequence;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.check();
            return this.delegate.charAt(i);
        }

        protected void check() {
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        @Override
        public String toString() {
            this.check();
            return ((Object)this.delegate).toString();
        }

        protected abstract void checkCanceled();

        @Override
        public CharSequence subSequence(int i, int i1) {
            this.check();
            return this.delegate.subSequence(i, i1);
        }
    }
}

